# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['CommodityReferencePriceEnum']

class CommodityReferencePriceEnum(Enum):
    """
    The enumeration values to specify the Commodity Reference Prices specified in the Annex to the 2005 ISDA Commodity Definitions.
    """
    ALUMINIUM_ALLOY_LME_15_MONTH = "ALUMINIUM ALLOY-LME 15 MONTH"
    """
    Per 2005 ISDA Commodity Definitions, Sub-Annex A, Section 7.1 Commodity Reference Prices, as amended and supplemented through the date on which parties enter into the relevant transaction.
    """
    COAL_CENTRAL_APPALACHIAN_NYMEX = "COAL-CENTRAL APPALACHIAN-NYMEX"
    """
    A code for the NYMEX Central Appalachian Coal commodity
    """
    COCOA_ICE = "COCOA-ICE"
    """
    A code for the ICE Futures U.S. (‘ICUS’) Cocoa commodity
    """
    COFFEE_ARABICA_ICE = "COFFEE ARABICA-ICE"
    """
    A code for the ICUS Coffee C commodity
    """
    COFFEE_ROBUSTA_ICE = "COFFEE ROBUSTA-ICE"
    """
    A code for the ICUS Coffee C commodity
    """
    COPPER_COMEX = "COPPER-COMEX"
    """
    A code for the COMEX (‘CMX’) Copper Grade #1 commodity
    """
    CORN_CBOT = "CORN-CBOT"
    """
    A code for the Chicago Board of Trade (‘CBOT’) Corn commodity
    """
    COTTON_NO__2_ICE = "COTTON NO. 2-ICE"
    """
    A code for the ICUS Cotton No. 2 commodity
    """
    ETHANOL_CBOT = "ETHANOL-CBOT"
    """
    A code for the CBOT Ethanol commodity
    """
    FEEDER_CATTLE_CME = "FEEDER CATTLE-CME"
    """
    A code for the CME Feeder Cattle commodity
    """
    FROZEN_CONCENTRATED_ORANGE_JUICE_NO__1_ICE = "FROZEN CONCENTRATED ORANGE JUICE NO. 1-ICE"
    """
    A code for the ICUS Frozen Concentrated Orange Juice commodity
    """
    GASOLINE_RBOB_NEW_YORK_ICE = "GASOLINE-RBOB-NEW YORK-ICE"
    """
    A code for the NYMEX Gasoline Blendstock (RBOB) commodity
    """
    GASOLINE_RBOB_NEW_YORK_NYMEX = "GASOLINE-RBOB-NEW YORK-NYMEX"
    """
    A code for the NYMEX Gasoline Blendstock (RBOB) commodity
    """
    GOLD_COMEX = "GOLD-COMEX"
    """
    A code for the CMX Gold commodity
    """
    HEATING_OIL_NEW_YORK_NYMEX = "HEATING OIL-NEW YORK-NYMEX"
    """
    A code for the NYMEX No. 2 Heating Oil, New York Harbor commodity
    """
    LEAN_HOGS_CME = "LEAN HOGS-CME"
    """
    A code for the CME Lean Hogs commodity
    """
    LIVE_CATTLE_CME = "LIVE CATTLE-CME"
    """
    A code for the CME Live Cattle commodity
    """
    LUMBER_CME = "LUMBER-CME"
    """
    A code for the CME Random Length Lumber commodity
    """
    MILK_CLASS_III_CME = "MILK-CLASS III-CME"
    """
    A code for the CME Milk Class III commodity
    """
    MILK_NONFAT_DRY_CME = "MILK-NONFAT-DRY-CME"
    """
    A code for the CME Non Fat Dry Milk commodity
    """
    NATURAL_GAS_NYMEX = "NATURAL GAS-NYMEX"
    """
    A code for the NYMEX Natural Gas commodity
    """
    NATURAL_GAS_PEPL__TEXOK_MAINLINE__INSIDE_FERC = "NATURAL GAS-PEPL (TEXOK MAINLINE)-INSIDE FERC"
    """
    A code for the NYMEX Panhandle Basis Swap commodity
    """
    NATURAL_GAS_W__TEXAS__WAHA__INSIDE_FERC = "NATURAL GAS-W. TEXAS (WAHA)-INSIDE FERC"
    """
    A code for the NYMEX Waha Basis Swap commodity
    """
    OATS_CBOT = "OATS-CBOT"
    """
    A code for the CBOT Oats commodity
    """
    OIL_WTI_NYMEX = "OIL-WTI-NYMEX"
    """
    A code for the NYMEX Crude Oil, Light Sweet commodity
    """
    PALLADIUM_NYMEX = "PALLADIUM-NYMEX"
    """
    A code for the NYMEX Palladium commodity
    """
    PLATINUM_NYMEX = "PLATINUM-NYMEX"
    """
    A code for the NYMEX Platinum commodity
    """
    RICE_CBOT = "RICE-CBOT"
    """
    A code for the CBOT Rough Rice commodity
    """
    SILVER_COMEX = "SILVER-COMEX"
    """
    A code for the CMX Silver commodity
    """
    SOYBEANS_CBOT = "SOYBEANS-CBOT"
    """
    A code for the CBOT Soybeans commodity
    """
    SOYBEAN_MEAL_CBOT = "SOYBEAN MEAL-CBOT"
    """
    A code for the CBOT Soybean Meal commodity
    """
    SOYBEAN_OIL_CBOT = "SOYBEAN OIL-CBOT"
    """
    A code for the CBOT Soybean Oil commodity
    """
    SUGAR___11__WORLD__ICE = "SUGAR # 11 (WORLD)-ICE"
    """
    A code for the ICUS Sugar No. 11 commodity
    """
    SUGAR___16__US__ICE = "SUGAR # 16 (US)-ICE"
    """
    A code for the ICUS Sugar No. 16 commodity
    """
    WHEAT_CBOT = "WHEAT-CBOT"
    """
    A code for the CBOT Wheat commodity
    """
    WHEAT_HRW_KCBOT = "WHEAT HRW-KCBOT"
    """
    A code for the Kansas City Board of Trade (‘KCBT’)Wheat commodity
    """
    WHEAT_RED_SPRING_MGE = "WHEAT RED SPRING-MGE"
    """
    A code for the Wheat commodity
    """
