# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestNotification']


class CollateralInterestNotification(BaseDataClass):
    """
    Represents the parameters describing when notifications should be made for required collateral interest transfers.
    """
    trigger: str = Field(..., description="Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.")
    """
    Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.
    """
    offset: Decimal = Field(..., description="Specifies the number of days before (negative) or after (positive) the trigger event.")
    """
    Specifies the number of days before (negative) or after (positive) the trigger event.
    """
    notificationTime: datetime.time = Field(..., description="Specifies the time of day that the notification should occur.")
    """
    Specifies the time of day that the notification should occur.
    """
    notificationDayType: cdm.base.datetime.DayTypeEnum.DayTypeEnum = Field(..., description="The type of days on which notification should occur.")
    """
    The type of days on which notification should occur.
    """

import cdm 
import cdm.base.datetime.DayTypeEnum
