# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityPayout']


class SecurityPayout(BaseDataClass):
    """
     Security payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction.
    """
    securityLeg: List[cdm.product.template.SecurityLeg.SecurityLeg] = Field([], description="Each SecurityLeg represent a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.")
    """
    Each SecurityLeg represent a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
    """
    @rosetta_condition
    def cardinality_securityLeg(self):
        return check_cardinality(self.securityLeg, 1, None)
    
    initialMargin: Optional[cdm.product.template.InitialMargin.InitialMargin] = Field(None, description="RepoDurationEnum.")
    """
    RepoDurationEnum.
    """
    repoDuration: Optional[cdm.product.template.RepoDurationEnum.RepoDurationEnum] = Field(None, description="A duration code for the repo transaction. This defines a type of a repo transaction with fixed duration.")
    """
    A duration code for the repo transaction. This defines a type of a repo transaction with fixed duration.
    """
    securityValuation: List[cdm.observable.asset.SecurityValuation.SecurityValuation] = Field([], description="The underlying securities and their valuation for the security leg.")
    """
    The underlying securities and their valuation for the security leg.
    """
    @rosetta_condition
    def cardinality_securityValuation(self):
        return check_cardinality(self.securityValuation, 1, None)
    

import cdm 
import cdm.product.template.SecurityLeg
import cdm.product.template.InitialMargin
import cdm.product.template.RepoDurationEnum
import cdm.observable.asset.SecurityValuation
