/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.validation.datarule;

import cdm.base.math.NumberRange;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NumberRangeAtLeastOneOf")
@ImplementedBy(value=Default.class)
public interface NumberRangeAtLeastOneOf
extends Validator<NumberRange> {
    public static final String NAME = "NumberRangeAtLeastOneOf";
    public static final String DEFINITION = "lowerBound exists or upperBound exists";

    public static class NoOp
    implements NumberRangeAtLeastOneOf {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NumberRange numberRange) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NumberRangeAtLeastOneOf {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NumberRange numberRange) {
            ComparisonResult result = this.executeDataRule(numberRange);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NumberRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NumberRange", (RosettaPath)path, (String)NumberRangeAtLeastOneOf.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NumberRangeAtLeastOneOf.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NumberRange", (RosettaPath)path, (String)NumberRangeAtLeastOneOf.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NumberRange numberRange) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)numberRange).map("getLowerBound", _numberRange -> _numberRange.getLowerBound())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)numberRange).map("getUpperBound", _numberRange -> _numberRange.getUpperBound())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

