/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SecurityEquitySubType")
@ImplementedBy(value=Default.class)
public interface SecurityEquitySubType
extends Validator<Security> {
    public static final String NAME = "SecurityEquitySubType";
    public static final String DEFINITION = "if securityType <> SecurityTypeEnum -> Equity then equityType is absent";

    public static class NoOp
    implements SecurityEquitySubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Security security) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SecurityEquitySubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Security security) {
            ComparisonResult result = this.executeDataRule(security);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SecurityEquitySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityEquitySubType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SecurityEquitySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Security", (RosettaPath)path, (String)SecurityEquitySubType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Security security) {
            try {
                if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)security).map("getSecurityType", _security -> _security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)security).map("getEquityType", _security -> _security.getEquityType()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

