/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="EventIntentEnum")
public enum EventIntentEnum {
    ALLOCATION("Allocation", null),
    CASH_FLOW("CashFlow", null),
    CLEARING("Clearing", null),
    COMPRESSION("Compression", null),
    CONTRACT_FORMATION("ContractFormation", null),
    CONTRACT_TERMS_AMENDMENT("ContractTermsAmendment", null),
    CORPORATE_ACTION_ADJUSTMENT("CorporateActionAdjustment", null),
    CREDIT_EVENT("CreditEvent", null),
    DECREASE("Decrease", null),
    EARLY_TERMINATION_PROVISION("EarlyTerminationProvision", null),
    INCREASE("Increase", null),
    INDEX_TRANSITION("IndexTransition", null),
    NOTIONAL_RESET("NotionalReset", null),
    NOTIONAL_STEP("NotionalStep", null),
    NOVATION("Novation", null),
    OBSERVATION_RECORD("ObservationRecord", null),
    OPTION_EXERCISE("OptionExercise", null),
    OPTIONAL_EXTENSION("OptionalExtension", null),
    OPTIONAL_CANCELLATION("OptionalCancellation", null),
    PORTFOLIO_REBALANCING("PortfolioRebalancing", null),
    PRINCIPAL_EXCHANGE("PrincipalExchange", null),
    REALLOCATION("Reallocation", null),
    REPURCHASE("Repurchase", null);

    private static Map<String, EventIntentEnum> values;
    private final String rosettaName;
    private final String displayName;

    private EventIntentEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static EventIntentEnum fromDisplayName(String name) {
        EventIntentEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, EventIntentEnum> map = new ConcurrentHashMap<String, EventIntentEnum>();
        for (EventIntentEnum instance : EventIntentEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

