/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.event.common.QuantityChangeInstruction;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_OnDemandRateChangePriceChangeInstructionDefault.class)
public abstract class Create_OnDemandRateChangePriceChangeInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public QuantityChangeInstruction evaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
        QuantityChangeInstruction quantityChangeInstruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists(this.currentRatePrice(priceQuantity, newRate)), "There should be 1 and only 1 rate type price in the current price.");
        QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstructionBuilder = this.doEvaluate(priceQuantity, newRate);
        if (quantityChangeInstructionBuilder == null) {
            quantityChangeInstruction = null;
        } else {
            quantityChangeInstruction = quantityChangeInstructionBuilder.build();
            this.objectValidator.validate(QuantityChangeInstruction.class, (RosettaModelObject)quantityChangeInstruction);
        }
        return quantityChangeInstruction;
    }

    protected abstract QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract MapperS<? extends FieldWithMetaPriceSchedule> currentRatePrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract MapperS<? extends Price> newPrice(List<? extends PriceQuantity> var1, BigDecimal var2);

    protected abstract MapperS<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> var1, BigDecimal var2);

    public static class Create_OnDemandRateChangePriceChangeInstructionDefault
    extends Create_OnDemandRateChangePriceChangeInstruction {
        @Override
        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder doEvaluate(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            if (priceQuantity == null) {
                priceQuantity = Collections.emptyList();
            }
            QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction = QuantityChangeInstruction.builder();
            return this.assignOutput(quantityChangeInstruction, priceQuantity, newRate);
        }

        protected QuantityChangeInstruction.QuantityChangeInstructionBuilder assignOutput(QuantityChangeInstruction.QuantityChangeInstructionBuilder quantityChangeInstruction, List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            quantityChangeInstruction = (QuantityChangeInstruction.QuantityChangeInstructionBuilder)this.toBuilder(QuantityChangeInstruction.builder().setChange(new ArrayList(this.newPriceQuantity(priceQuantity, newRate).getMulti())).setDirection(QuantityChangeDirectionEnum.REPLACE).setLotIdentifier(Collections.emptyList()).build());
            return Optional.ofNullable(quantityChangeInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends FieldWithMetaPriceSchedule> currentRatePrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            MapperListOfLists thenArg0 = MapperC.of(priceQuantity).mapItemToList(item -> item.mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()));
            MapperC thenArg1 = thenArg0.flattenList();
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((FieldWithMetaPriceSchedule)thenArg2.get()));
        }

        @Override
        protected MapperS<? extends Price> newPrice(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)Price.builder().setValue(newRate).setUnit((UnitType)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).get()).setPerUnitOf((UnitType)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get()).setPriceType((PriceTypeEnum)((Object)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule2 -> fieldWithMetaPriceSchedule2 == null ? null : fieldWithMetaPriceSchedule2.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get())).setPriceExpression((PriceExpressionEnum)((Object)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule3 -> fieldWithMetaPriceSchedule3 == null ? null : fieldWithMetaPriceSchedule3.getValue()).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get())).setComposite((PriceComposite)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule4 -> fieldWithMetaPriceSchedule4 == null ? null : fieldWithMetaPriceSchedule4.getValue()).map("getComposite", priceSchedule -> priceSchedule.getComposite()).get()).setArithmeticOperator((ArithmeticOperationEnum)((Object)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule5 -> fieldWithMetaPriceSchedule5 == null ? null : fieldWithMetaPriceSchedule5.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()).get())).setCashPrice((CashPrice)this.currentRatePrice(priceQuantity, newRate).map("Type coercion", fieldWithMetaPriceSchedule6 -> fieldWithMetaPriceSchedule6 == null ? null : fieldWithMetaPriceSchedule6.getValue()).map("getCashPrice", priceSchedule -> priceSchedule.getCashPrice()).get()).setDatedValue(Collections.emptyList()).build());
        }

        @Override
        protected MapperS<? extends PriceQuantity> newPriceQuantity(List<? extends PriceQuantity> priceQuantity, BigDecimal newRate) {
            return MapperS.of((Object)PriceQuantity.builder().setPriceValue(new ArrayList(this.newPrice(priceQuantity, newRate).getMulti())).build());
        }
    }
}

