/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.FloatingRateOption;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FloatingRateOptionIndexRefInfo")
@ImplementedBy(value=Default.class)
public interface FloatingRateOptionIndexRefInfo
extends Validator<FloatingRateOption> {
    public static final String NAME = "FloatingRateOptionIndexRefInfo";
    public static final String DEFINITION = "if floatingRateIndex is absent and inflationRateIndex is absent then indexReferenceInformation exists";

    public static class NoOp
    implements FloatingRateOptionIndexRefInfo {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FloatingRateOptionIndexRefInfo {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateOption floatingRateOption) {
            ComparisonResult result = this.executeDataRule(floatingRateOption);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FloatingRateOptionIndexRefInfo.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FloatingRateOption", (RosettaPath)path, (String)FloatingRateOptionIndexRefInfo.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FloatingRateOptionIndexRefInfo.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FloatingRateOption", (RosettaPath)path, (String)FloatingRateOptionIndexRefInfo.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FloatingRateOption floatingRateOption) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)floatingRateOption).map("getFloatingRateIndex", _floatingRateOption -> _floatingRateOption.getFloatingRateIndex())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)floatingRateOption).map("getInflationRateIndex", _floatingRateOption -> _floatingRateOption.getInflationRateIndex()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)floatingRateOption).map("getIndexReferenceInformation", _floatingRateOption -> _floatingRateOption.getIndexReferenceInformation()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

