/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.Rounding;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.functions.ApplyCapsAndFloors;
import cdm.product.asset.floatingrate.functions.ApplyFinalRateRounding;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ApplyFloatingRatePostSpreadProcessingDefault.class)
public abstract class ApplyFloatingRatePostSpreadProcessing
implements RosettaFunction {
    @Inject
    protected ApplyCapsAndFloors applyCapsAndFloors;
    @Inject
    protected ApplyFinalRateRounding applyFinalRateRounding;

    public BigDecimal evaluate(BigDecimal inputRate, FloatingRateProcessingParameters processing) {
        BigDecimal processedRate = this.doEvaluate(inputRate, processing);
        return processedRate;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, FloatingRateProcessingParameters var2);

    protected abstract MapperS<BigDecimal> cappedAndFlooredRate(BigDecimal var1, FloatingRateProcessingParameters var2);

    public static class ApplyFloatingRatePostSpreadProcessingDefault
    extends ApplyFloatingRatePostSpreadProcessing {
        @Override
        protected BigDecimal doEvaluate(BigDecimal inputRate, FloatingRateProcessingParameters processing) {
            BigDecimal processedRate = null;
            return this.assignOutput(processedRate, inputRate, processing);
        }

        protected BigDecimal assignOutput(BigDecimal processedRate, BigDecimal inputRate, FloatingRateProcessingParameters processing) {
            processedRate = this.applyFinalRateRounding.evaluate((BigDecimal)this.cappedAndFlooredRate(inputRate, processing).get(), (Rounding)MapperS.of((Object)processing).map("getRounding", floatingRateProcessingParameters -> floatingRateProcessingParameters.getRounding()).get());
            return processedRate;
        }

        @Override
        protected MapperS<BigDecimal> cappedAndFlooredRate(BigDecimal inputRate, FloatingRateProcessingParameters processing) {
            return MapperS.of((Object)this.applyCapsAndFloors.evaluate(processing, inputRate));
        }
    }
}

