/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InterestRatePayoutCashSettlementTerms")
@ImplementedBy(value=Default.class)
public interface InterestRatePayoutCashSettlementTerms
extends Validator<InterestRatePayout> {
    public static final String NAME = "InterestRatePayoutCashSettlementTerms";
    public static final String DEFINITION = "if settlementTerms -> settlementCurrency exists and (settlementTerms -> settlementCurrency <> priceQuantity -> quantitySchedule -> unit -> currency or settlementTerms -> settlementCurrency <> priceQuantity -> quantityMultiplier -> fxLinkedNotionalSchedule -> varyingNotionalCurrency) then (settlementTerms -> cashSettlementTerms -> valuationMethod exists and settlementTerms -> cashSettlementTerms -> valuationDate exists) or priceQuantity -> quantityMultiplier -> fxLinkedNotionalSchedule -> fxSpotRateSource exists";

    public static class NoOp
    implements InterestRatePayoutCashSettlementTerms {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRatePayout interestRatePayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InterestRatePayoutCashSettlementTerms {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRatePayout interestRatePayout) {
            ComparisonResult result = this.executeDataRule(interestRatePayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InterestRatePayoutCashSettlementTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutCashSettlementTerms.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InterestRatePayoutCashSettlementTerms.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutCashSettlementTerms.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(InterestRatePayout interestRatePayout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency()).map("Type coercion", fieldWithMetaString2 -> fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()), (Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantityMultiplier", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityMultiplier()).map("getFxLinkedNotionalSchedule", quantityMultiplier -> quantityMultiplier.getFxLinkedNotionalSchedule()).map("getVaryingNotionalCurrency", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalCurrency()).map("Type coercion", fieldWithMetaString3 -> fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue()), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()).map("getValuationMethod", cashSettlementTerms -> cashSettlementTerms.getValuationMethod())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()).map("getValuationDate", cashSettlementTerms -> cashSettlementTerms.getValuationDate()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantityMultiplier", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityMultiplier()).map("getFxLinkedNotionalSchedule", quantityMultiplier -> quantityMultiplier.getFxLinkedNotionalSchedule()).map("getFxSpotRateSource", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getFxSpotRateSource())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

