/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.staticdata.party.LegalEntity;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=CheckIssuerNameDefault.class)
public abstract class CheckIssuerName
implements RosettaFunction {
    public Boolean evaluate(List<? extends LegalEntity> issuerName, EligibilityQuery query) {
        Boolean isEqual = this.doEvaluate(issuerName, query);
        return isEqual;
    }

    protected abstract Boolean doEvaluate(List<? extends LegalEntity> var1, EligibilityQuery var2);

    public static class CheckIssuerNameDefault
    extends CheckIssuerName {
        @Override
        protected Boolean doEvaluate(List<? extends LegalEntity> issuerName, EligibilityQuery query) {
            if (issuerName == null) {
                issuerName = Collections.emptyList();
            }
            Boolean isEqual = null;
            return this.assignOutput(isEqual, issuerName, query);
        }

        protected Boolean assignOutput(Boolean isEqual, List<? extends LegalEntity> issuerName, EligibilityQuery query) {
            isEqual = ExpressionOperators.notExists((Mapper)MapperC.of(issuerName)).or(ExpressionOperators.contains((Mapper)MapperC.of(issuerName), (Mapper)MapperS.of((Object)query).map("getIssuerName", eligibilityQuery -> eligibilityQuery.getIssuerName()))).get();
            return isEqual;
        }
    }
}

