/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public class TotalNotionalQuantityMappingProcessor
extends MappingProcessor {
    public TotalNotionalQuantityMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        List<? extends RosettaModelObjectBuilder> quantityBuilders = builders;
        this.getTotalNotionalQuantity(synonymPath, quantityBuilders.size()).map(PriceQuantityHelper::toReferencableQuantityBuilder).ifPresent(quantityBuilders::add);
    }

    private Optional<NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder> getTotalNotionalQuantity(Path synonymPath, int index) {
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityBuilder = NonNegativeQuantitySchedule.builder();
        Path baseModelPath = PathUtils.toPath((RosettaPath)this.getModelPath()).addElement("amount");
        Path mappedModelPath = PriceQuantityHelper.incrementPathElementIndex(baseModelPath, "quantity", index);
        MappingProcessorUtils.getNonNullMappedValue((Path)synonymPath, (List)this.getMappings()).ifPresent(xmlValue -> {
            quantityBuilder.setValue(new BigDecimal((String)xmlValue)).setUnit(UnitType.builder().setCapacityUnit(this.findCapacityUnitEnum(synonymPath.getParent())));
            this.addMapping(synonymPath, xmlValue, mappedModelPath, xmlValue);
        });
        return quantityBuilder.hasData() ? Optional.of(quantityBuilder) : Optional.empty();
    }

    private CapacityUnitEnum findCapacityUnitEnum(Path legSynonymPath) {
        return this.getCapacityUnitEnum(legSynonymPath.addElement("notionalQuantity").addElement("quantityUnit")).orElse(this.getCapacityUnitEnum(legSynonymPath.addElement("notionalQuantitySchedule").addElement("notionalStep").addElement("quantityUnit")).orElse(null));
    }

    private Optional<CapacityUnitEnum> getCapacityUnitEnum(Path quantityUnitPath) {
        return MappingProcessorUtils.getNonNullMappedValue((Path)quantityUnitPath, (List)this.getMappings()).flatMap(xmlValue -> this.getSynonymToEnumMap().getEnumValueOptional(CapacityUnitEnum.class, xmlValue));
    }

    private void addMapping(Path xmlPath, Object xmlValue, Path modelPath, Object modelValue) {
        this.getMappings().add(new Mapping(xmlPath, xmlValue, modelPath, modelValue, null, true, true, false));
    }
}

