/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.MoreObjects;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class ResourceLocator {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PREFIX = "url:";
    private final String locator;
    private final ByteSource source;

    @FromString
    public static ResourceLocator of(String locator) {
        ArgChecker.notNull(locator, "locator");
        try {
            if (locator.startsWith(CLASSPATH_URL_PREFIX)) {
                String urlStr = locator.substring(CLASSPATH_URL_PREFIX.length());
                return ResourceLocator.ofClasspath(urlStr);
            }
            if (locator.startsWith(FILE_URL_PREFIX)) {
                String fileStr = locator.substring(FILE_URL_PREFIX.length());
                return ResourceLocator.ofFile(new File(fileStr));
            }
            if (locator.startsWith(URL_PREFIX)) {
                String pathStr = locator.substring(URL_PREFIX.length());
                return ResourceLocator.ofUrl(new URL(pathStr));
            }
            return ResourceLocator.ofFile(new File(locator));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid resource locator: " + locator, ex);
        }
    }

    public static ResourceLocator ofFile(File file) {
        ArgChecker.notNull(file, "file");
        String filename = file.toString();
        filename = File.separatorChar == '\\' ? filename.replace('\\', '/') : filename;
        return new ResourceLocator(FILE_URL_PREFIX + filename, Files.asByteSource((File)file));
    }

    public static ResourceLocator ofPath(Path path) {
        ArgChecker.notNull(path, "path");
        try {
            return ResourceLocator.ofFile(path.toFile());
        }
        catch (UnsupportedOperationException ex) {
            try {
                return ResourceLocator.ofUrl(path.toUri().toURL());
            }
            catch (MalformedURLException ex2) {
                throw new IllegalArgumentException("Path could not be converted to a File or URL: " + path);
            }
        }
    }

    public static ResourceLocator ofUrl(URL url) {
        ArgChecker.notNull(url, "url");
        String filename = url.toString();
        return new ResourceLocator(URL_PREFIX + filename, Resources.asByteSource((URL)url));
    }

    public static ResourceLocator ofClasspath(String resourceName) {
        ArgChecker.notNull(resourceName, "classpathLocator");
        URL url = ResourceLocator.classLoader().getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resourceName);
        }
        return ResourceLocator.ofClasspathUrl(url);
    }

    public static ResourceLocator ofClasspath(Class<?> cls, String resourceName) {
        ArgChecker.notNull(resourceName, "classpathLocator");
        URL url = cls.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resourceName);
        }
        return ResourceLocator.ofClasspathUrl(url);
    }

    public static ResourceLocator ofClasspathUrl(URL url) {
        ArgChecker.notNull(url, "url");
        String locator = CLASSPATH_URL_PREFIX + url.toString();
        return new ResourceLocator(locator, Resources.asByteSource((URL)url));
    }

    static ClassLoader classLoader() {
        return (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ResourceConfig.class.getClassLoader());
    }

    private ResourceLocator(String locator, ByteSource source) {
        this.locator = locator;
        this.source = source;
    }

    public String getLocator() {
        return this.locator;
    }

    public ByteSource getByteSource() {
        return this.source;
    }

    public CharSource getCharSource() {
        return UnicodeBom.toCharSource(this.source);
    }

    public CharSource getCharSource(Charset charset) {
        return this.source.asCharSource(charset);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourceLocator) {
            return this.locator.equals(((ResourceLocator)obj).locator);
        }
        return false;
    }

    public int hashCode() {
        return this.locator.hashCode();
    }

    @ToString
    public String toString() {
        return this.locator;
    }
}

