/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Failure;
import com.opengamma.strata.collect.result.FailureItem;
import com.opengamma.strata.collect.result.FailureReason;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Result<T>
implements ImmutableBean,
Serializable {
    @PropertyDefinition(get="field")
    private final T value;
    @PropertyDefinition(get="field")
    private final Failure failure;
    private static final long serialVersionUID = 1L;

    public static <R> Result<R> success(R value) {
        return new Result<R>(ArgChecker.notNull(value, "value"));
    }

    public static <R> Result<R> failure(FailureReason reason, String message, Object ... messageArgs) {
        String msg = Messages.format(message, messageArgs);
        return new Result(Failure.of(FailureItem.of(reason, msg, 1)));
    }

    public static <T> Result<T> of(Supplier<T> supplier) {
        try {
            return Result.success(supplier.get());
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public static <T> Result<T> wrap(Supplier<Result<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public static <R> Result<R> failure(Exception exception) {
        return new Result(Failure.of(FailureReason.ERROR, exception));
    }

    public static <R> Result<R> failure(Exception exception, String message, Object ... messageArgs) {
        return new Result(Failure.of(FailureReason.ERROR, exception, message, messageArgs));
    }

    public static <R> Result<R> failure(FailureReason reason, Exception exception) {
        return new Result(Failure.of(reason, exception));
    }

    public static <R> Result<R> failure(FailureReason reason, Exception exception, String message, Object ... messageArgs) {
        return new Result(Failure.of(reason, exception, message, messageArgs));
    }

    public static <R> Result<R> failure(Result<?> failureResult) {
        if (failureResult.isSuccess()) {
            throw new IllegalArgumentException("Result must be a failure");
        }
        return failureResult;
    }

    public static <R> Result<R> failure(Result<?> result1, Result<?> result2, Result<?> ... results) {
        ArgChecker.notNull(result1, "result1");
        ArgChecker.notNull(result2, "result2");
        ArgChecker.notNull(results, "results");
        ImmutableList list = ImmutableList.builder().add(result1).add(result2).addAll(Arrays.asList(results)).build();
        return Result.failure(list);
    }

    public static <R> Result<R> failure(Iterable<? extends Result<?>> results) {
        ArgChecker.notEmpty(results, "results");
        ImmutableSet items = Guavate.stream(results).filter(Result::isFailure).map(Result::getFailure).flatMap((? super T f) -> f.getItems().stream()).collect(Guavate.toImmutableSet());
        if (items.isEmpty()) {
            throw new IllegalArgumentException("All results were successes");
        }
        return new Result(Failure.of(items));
    }

    public static <R> Result<R> failure(Failure failure) {
        return new Result(failure);
    }

    public static <R> Result<R> ofNullable(R value, FailureReason reason, String message, Object ... messageArgs) {
        if (value != null) {
            return Result.success(value);
        }
        return Result.failure(reason, message, messageArgs);
    }

    public static <R> Result<R> ofNullable(R value) {
        return Result.ofNullable(value, FailureReason.MISSING_DATA, "Found null where a value was expected", new Object[0]);
    }

    public static boolean allSuccessful(Result<?> ... results) {
        return Stream.of(results).allMatch(Result::isSuccess);
    }

    public static boolean allSuccessful(Iterable<? extends Result<?>> results) {
        return Guavate.stream(results).allMatch(Result::isSuccess);
    }

    public static boolean anyFailures(Result<?> ... results) {
        return Stream.of(results).anyMatch(Result::isFailure);
    }

    public static boolean anyFailures(Iterable<? extends Result<?>> results) {
        return Guavate.stream(results).anyMatch(Result::isFailure);
    }

    public static long countFailures(Result<?> ... results) {
        return Stream.of(results).filter(Result::isFailure).count();
    }

    public static long countFailures(Iterable<? extends Result<?>> results) {
        return Guavate.stream(results).filter(Result::isFailure).count();
    }

    public static <T, R> Result<R> combine(Iterable<? extends Result<T>> results, Function<Stream<T>, R> function) {
        try {
            return Result.allSuccessful(results) ? Result.success(function.apply(Result.extractSuccesses(results))) : Result.failure(results);
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public static <T, R> Result<R> flatCombine(Iterable<? extends Result<T>> results, Function<Stream<T>, Result<R>> function) {
        try {
            return Result.allSuccessful(results) ? function.apply(Result.extractSuccesses(results)) : Result.failure(results);
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    private static <T> Stream<T> extractSuccesses(Iterable<? extends Result<T>> results) {
        return Guavate.stream(results).map(Result::getValue);
    }

    private Result(T value) {
        this.value = value;
        this.failure = null;
    }

    private Result(Failure failure) {
        this.value = null;
        this.failure = failure;
    }

    private void validate() {
        if (this.value == null && this.failure == null) {
            throw new IllegalArgumentException("Both value and failure are null");
        }
        if (this.value != null && this.failure != null) {
            throw new IllegalArgumentException("Both value and failure are non-null");
        }
    }

    public boolean isSuccess() {
        return this.value != null;
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public T getValue() {
        if (this.isFailure()) {
            throw new IllegalStateException("Unable to get a value from a failure result: " + this.getFailure().getMessage());
        }
        return this.value;
    }

    public T getValueOrElse(T defaultValue) {
        ArgChecker.notNull(defaultValue, "defaultValue");
        return this.isSuccess() ? this.value : defaultValue;
    }

    public T getValueOrElseApply(Function<Failure, T> mapper) {
        ArgChecker.notNull(mapper, "mapper");
        return this.isSuccess() ? this.value : mapper.apply(this.failure);
    }

    public Failure getFailure() {
        if (this.isSuccess()) {
            throw new IllegalStateException("Unable to get a failure from a success result");
        }
        return this.failure;
    }

    public <R> Result<R> map(Function<? super T, ? extends R> function) {
        if (this.isSuccess()) {
            try {
                return Result.success(function.apply(this.value));
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }
        return Result.failure(this);
    }

    public <R> Result<R> flatMap(Function<? super T, Result<R>> function) {
        if (this.isSuccess()) {
            try {
                return Objects.requireNonNull(function.apply(this.value));
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }
        return Result.failure(this);
    }

    public <U, R> Result<R> combineWith(Result<U> other, BiFunction<T, U, Result<R>> function) {
        ArgChecker.notNull(other, "other");
        ArgChecker.notNull(function, "function");
        if (this.isSuccess() && other.isSuccess()) {
            try {
                return Objects.requireNonNull(function.apply(this.value, other.value));
            }
            catch (Exception e) {
                return Result.failure(e);
            }
        }
        return Result.failure(this, other, new Result[0]);
    }

    public Stream<T> stream() {
        return this.isSuccess() ? Stream.of(this.value) : Stream.empty();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaResult(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private Result(T value, Failure failure) {
        this.value = value;
        this.failure = failure;
        this.validate();
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Result other = (Result)obj;
            return JodaBeanUtils.equal(this.value, other.value) && JodaBeanUtils.equal((Object)this.failure, (Object)other.failure);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.failure);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("Result{");
        buf.append("value").append('=').append(this.value).append(',').append(' ');
        buf.append("failure").append('=').append(JodaBeanUtils.toString((Object)this.failure));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<T>
    extends DirectPrivateBeanBuilder<Result<T>> {
        private T value;
        private Failure failure;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case -1086574198: {
                    return this.failure;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = newValue;
                    break;
                }
                case -1086574198: {
                    this.failure = (Failure)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Result<T> build() {
            return new Result(this.value, this.failure);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Result.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value)).append(',').append(' ');
            buf.append("failure").append('=').append(JodaBeanUtils.toString((Object)this.failure));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<T> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", Result.class, Object.class);
        private final MetaProperty<Failure> failure = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"failure", Result.class, Failure.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "failure"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case -1086574198: {
                    return this.failure;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Result<T>> builder() {
            return new Builder();
        }

        public Class<? extends Result<T>> beanType() {
            return Result.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<T> value() {
            return this.value;
        }

        public MetaProperty<Failure> failure() {
            return this.failure;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((Result)bean).value;
                }
                case -1086574198: {
                    return ((Result)bean).failure;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

