/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.tuple;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.tuple.Tuple;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Triple<A, B, C>
implements ImmutableBean,
Tuple,
Comparable<Triple<A, B, C>>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final A first;
    @PropertyDefinition(validate="notNull")
    private final B second;
    @PropertyDefinition(validate="notNull")
    private final C third;
    private static final long serialVersionUID = 1L;

    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    @Override
    public int size() {
        return 3;
    }

    public ImmutableList<Object> elements() {
        return ImmutableList.of(this.first, this.second, this.third);
    }

    @Override
    public int compareTo(Triple<A, B, C> other) {
        return ComparisonChain.start().compare((Comparable)this.first, (Comparable)other.first).compare((Comparable)this.second, (Comparable)other.second).compare((Comparable)this.third, (Comparable)other.third).result();
    }

    public String toString() {
        return "" + '[' + this.first + ", " + this.second + ", " + this.third + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R, S, T> Meta<R, S, T> metaTriple(Class<R> cls1, Class<S> cls2, Class<T> cls3) {
        return Meta.INSTANCE;
    }

    private Triple(A first, B second, C third) {
        JodaBeanUtils.notNull(first, (String)"first");
        JodaBeanUtils.notNull(second, (String)"second");
        JodaBeanUtils.notNull(third, (String)"third");
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public Meta<A, B, C> metaBean() {
        return Meta.INSTANCE;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public C getThird() {
        return this.third;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Triple other = (Triple)obj;
            return JodaBeanUtils.equal(this.first, other.first) && JodaBeanUtils.equal(this.second, other.second) && JodaBeanUtils.equal(this.third, other.third);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.first);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.second);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.third);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<A, B, C>
    extends DirectPrivateBeanBuilder<Triple<A, B, C>> {
        private A first;
        private B second;
        private C third;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
                case 110331239: {
                    return this.third;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<A, B, C> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    this.first = newValue;
                    break;
                }
                case -906279820: {
                    this.second = newValue;
                    break;
                }
                case 110331239: {
                    this.third = newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Triple<A, B, C> build() {
            return new Triple(this.first, this.second, this.third);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Triple.Builder{");
            buf.append("first").append('=').append(JodaBeanUtils.toString(this.first)).append(',').append(' ');
            buf.append("second").append('=').append(JodaBeanUtils.toString(this.second)).append(',').append(' ');
            buf.append("third").append('=').append(JodaBeanUtils.toString(this.third));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<A, B, C>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<A> first = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"first", Triple.class, Object.class);
        private final MetaProperty<B> second = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"second", Triple.class, Object.class);
        private final MetaProperty<C> third = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"third", Triple.class, Object.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"first", "second", "third"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
                case 110331239: {
                    return this.third;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Triple<A, B, C>> builder() {
            return new Builder();
        }

        public Class<? extends Triple<A, B, C>> beanType() {
            return Triple.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<A> first() {
            return this.first;
        }

        public MetaProperty<B> second() {
            return this.second;
        }

        public MetaProperty<C> third() {
            return this.third;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return ((Triple)bean).getFirst();
                }
                case -906279820: {
                    return ((Triple)bean).getSecond();
                }
                case 110331239: {
                    return ((Triple)bean).getThird();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

