/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.projection.iso20022.esma.emir.refit.margin.functions.Create_MarginReportData;
import drr.projection.iso20022.esma.emir.refit.margin.labels.Project_EsmaEmirMarginReportToIso20022LabelProvider;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.esma.emir.refit.margin.CollateralReport;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative;
import iso20022.auth108.esma.Document;
import iso20022.auth108.esma.MarginReportData7__1;
import iso20022.auth108.esma.TradeReport31Choice__1;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@RuneLabelProvider(labelProvider=Project_EsmaEmirMarginReportToIso20022LabelProvider.class)
@ImplementedBy(value=Project_EsmaEmirMarginReportToIso20022Default.class)
public abstract class Project_EsmaEmirMarginReportToIso20022
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_MarginReportData create_MarginReportData;

    public Document evaluate(ESMAEMIRMarginReport marginReport) {
        Document iso20022Report;
        Document.DocumentBuilder iso20022ReportBuilder = this.doEvaluate(marginReport);
        if (iso20022ReportBuilder == null) {
            iso20022Report = null;
        } else {
            iso20022Report = iso20022ReportBuilder.build();
            this.objectValidator.validate(Document.class, (RosettaModelObject)iso20022Report);
        }
        return iso20022Report;
    }

    protected abstract Document.DocumentBuilder doEvaluate(ESMAEMIRMarginReport var1);

    public static class Project_EsmaEmirMarginReportToIso20022Default
    extends Project_EsmaEmirMarginReportToIso20022 {
        @Override
        protected Document.DocumentBuilder doEvaluate(ESMAEMIRMarginReport marginReport) {
            Document.DocumentBuilder iso20022Report = Document.builder();
            return this.assignOutput(iso20022Report, marginReport);
        }

        protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder iso20022Report, ESMAEMIRMarginReport marginReport) {
            MarginReportData7__1 ifThenElseResult0 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)marginReport).map("getCollateral", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getCollateral()).map("getActionType", collateralReport -> collateralReport.getActionType()), (Mapper)MapperS.of((Object)((Object)MarginActionEnum.MARU)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = this.create_MarginReportData.evaluate((PartiesToTheDerivative)MapperS.of((Object)marginReport).map("getPartiesToTheDerivative", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getPartiesToTheDerivative()).get(), (CollateralReport)MapperS.of((Object)marginReport).map("getCollateral", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getCollateral()).get());
            }
            MarginReportData7__1 ifThenElseResult1 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)marginReport).map("getCollateral", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getCollateral()).map("getActionType", collateralReport -> collateralReport.getActionType()), (Mapper)MapperS.of((Object)((Object)MarginActionEnum.CORR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = this.create_MarginReportData.evaluate((PartiesToTheDerivative)MapperS.of((Object)marginReport).map("getPartiesToTheDerivative", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getPartiesToTheDerivative()).get(), (CollateralReport)MapperS.of((Object)marginReport).map("getCollateral", eSMAEMIRMarginReport -> eSMAEMIRMarginReport.getCollateral()).get());
            }
            TradeReport31Choice__1 tradeReport31Choice__1 = TradeReport31Choice__1.builder().setMrgnUpd(ifThenElseResult0).setCrrctn(ifThenElseResult1).build();
            iso20022Report.getOrCreateDerivsTradMrgnDataRpt().getOrCreateTradData().setRpt(tradeReport31Choice__1 == null ? Collections.emptyList() : Collections.singletonList(tradeReport31Choice__1));
            return Optional.ofNullable(iso20022Report).map(o -> o.prune()).orElse(null);
        }
    }
}

