/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.CurrencyExchange22__1;
import iso20022.auth030.fca.ExchangeRateBasis1;
import iso20022.auth030.fca.ExchangeRateBasis1Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCcyDefault.class)
public abstract class GetCcy
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected SubString subString;

    public CurrencyExchange22__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        CurrencyExchange22__1 ccy;
        CurrencyExchange22__1.CurrencyExchange22__1Builder ccyBuilder = this.doEvaluate(drrReport);
        if (ccyBuilder == null) {
            ccy = null;
        } else {
            ccy = ccyBuilder.build();
            this.objectValidator.validate(CurrencyExchange22__1.class, (RosettaModelObject)ccy);
        }
        return ccy;
    }

    protected abstract CurrencyExchange22__1.CurrencyExchange22__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetCcyDefault
    extends GetCcy {
        @Override
        protected CurrencyExchange22__1.CurrencyExchange22__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            CurrencyExchange22__1.CurrencyExchange22__1Builder ccy = CurrencyExchange22__1.builder();
            return this.assignOutput(ccy, drrReport);
        }

        protected CurrencyExchange22__1.CurrencyExchange22__1Builder assignOutput(CurrencyExchange22__1.CurrencyExchange22__1Builder ccy, FCAUKEMIRTransactionReport drrReport) {
            String ifThenElseResult0 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getExchangeRateBasis()).get(), 1, 3);
            }
            String ifThenElseResult1 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getExchangeRateBasis()).get(), 5, 3);
            }
            ccy = (CurrencyExchange22__1.CurrencyExchange22__1Builder)this.toBuilder((RosettaModelObject)CurrencyExchange22__1.builder().setXchgRate((BigDecimal)MapperS.of((Object)drrReport).map("getExchangeRate", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getExchangeRate()).get()).setFwdXchgRate((BigDecimal)MapperS.of((Object)drrReport).map("getForwardExchangeRate", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getForwardExchangeRate()).get()).setXchgRateBsis(ExchangeRateBasis1Choice__1.builder().setCcyPair(ExchangeRateBasis1.builder().setBaseCcy(ifThenElseResult0).setQtdCcy(ifThenElseResult1).build()).build()).build());
            return Optional.ofNullable(ccy).map(o -> o.prune()).orElse(null);
        }
    }
}

