/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.labels.ASICTradeLabelProvider;
import drr.regulation.asic.rewrite.trade.reports.ActionTypeRule;
import drr.regulation.asic.rewrite.trade.reports.AssetClassRule;
import drr.regulation.asic.rewrite.trade.reports.BasketConstituentsRule;
import drr.regulation.asic.rewrite.trade.reports.BasketStructurerRule;
import drr.regulation.asic.rewrite.trade.reports.Beneficiary1IdentifierTypeIndicatorRule;
import drr.regulation.asic.rewrite.trade.reports.Beneficiary1Rule;
import drr.regulation.asic.rewrite.trade.reports.BrokerRule;
import drr.regulation.asic.rewrite.trade.reports.CDSIndexAttachmentPointRule;
import drr.regulation.asic.rewrite.trade.reports.CDSIndexDetachmentPointRule;
import drr.regulation.asic.rewrite.trade.reports.CallAmountRule;
import drr.regulation.asic.rewrite.trade.reports.CallCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.CentralCounterpartyRule;
import drr.regulation.asic.rewrite.trade.reports.ClearedRule;
import drr.regulation.asic.rewrite.trade.reports.ClearingMemberRule;
import drr.regulation.asic.rewrite.trade.reports.ClearingTimestampRule;
import drr.regulation.asic.rewrite.trade.reports.CollateralPortfolioCodeInitialMarginRule;
import drr.regulation.asic.rewrite.trade.reports.CollateralPortfolioCodeVariationMarginRule;
import drr.regulation.asic.rewrite.trade.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.asic.rewrite.trade.reports.ContractTypeRule;
import drr.regulation.asic.rewrite.trade.reports.Counterparty1Rule;
import drr.regulation.asic.rewrite.trade.reports.Counterparty2IdentifierTypeIndicatorRule;
import drr.regulation.asic.rewrite.trade.reports.Counterparty2NameRule;
import drr.regulation.asic.rewrite.trade.reports.Counterparty2Rule;
import drr.regulation.asic.rewrite.trade.reports.CountryOfCounterparty2Rule;
import drr.regulation.asic.rewrite.trade.reports.DeltaRule;
import drr.regulation.asic.rewrite.trade.reports.Direction1Rule;
import drr.regulation.asic.rewrite.trade.reports.EffectiveDateRule;
import drr.regulation.asic.rewrite.trade.reports.EventTimestampRule;
import drr.regulation.asic.rewrite.trade.reports.EventTypeRule;
import drr.regulation.asic.rewrite.trade.reports.ExchangeRateBasisRule;
import drr.regulation.asic.rewrite.trade.reports.ExchangeRateRule;
import drr.regulation.asic.rewrite.trade.reports.ExecutionAgentCounterparty1Rule;
import drr.regulation.asic.rewrite.trade.reports.ExecutionAgentCounterparty2DTCCRule;
import drr.regulation.asic.rewrite.trade.reports.ExecutionTimestampRule;
import drr.regulation.asic.rewrite.trade.reports.ExpirationDateRule;
import drr.regulation.asic.rewrite.trade.reports.IndexFactorRule;
import drr.regulation.asic.rewrite.trade.reports.Leg1ReportRule;
import drr.regulation.asic.rewrite.trade.reports.Leg2ReportRule;
import drr.regulation.asic.rewrite.trade.reports.MaturityDateOfTheUnderlierRule;
import drr.regulation.asic.rewrite.trade.reports.NewDerivativeTradeRepositoryRule;
import drr.regulation.asic.rewrite.trade.reports.OptionPremiumAmountRule;
import drr.regulation.asic.rewrite.trade.reports.OptionPremiumCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.OptionPremiumPaymentDateRule;
import drr.regulation.asic.rewrite.trade.reports.OtherPaymentRule;
import drr.regulation.asic.rewrite.trade.reports.PackageIdentifierRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionPriceCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionPriceRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionSpreadCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionSpreadNotationRule;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionSpreadRule;
import drr.regulation.asic.rewrite.trade.reports.PlatformIdentifierRule;
import drr.regulation.asic.rewrite.trade.reports.PriceCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.PriceNotationRule;
import drr.regulation.asic.rewrite.trade.reports.PriceRule;
import drr.regulation.asic.rewrite.trade.reports.PriceUnitOfMeasureRule;
import drr.regulation.asic.rewrite.trade.reports.PriorUTIProprietaryRule;
import drr.regulation.asic.rewrite.trade.reports.PriorUTIRule;
import drr.regulation.asic.rewrite.trade.reports.PutAmountRule;
import drr.regulation.asic.rewrite.trade.reports.PutCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.ReportSubmittingEntityRule;
import drr.regulation.asic.rewrite.trade.reports.ReportingTimestampRule;
import drr.regulation.asic.rewrite.trade.reports.SingleOrUpperAndLowerBarrierRule;
import drr.regulation.asic.rewrite.trade.reports.SmallScaleBuySideEntityIndicatorRule;
import drr.regulation.asic.rewrite.trade.reports.StrikePriceCurrencyCurrencyPairRule;
import drr.regulation.asic.rewrite.trade.reports.StrikePriceNotationRule;
import drr.regulation.asic.rewrite.trade.reports.StrikePriceRule;
import drr.regulation.asic.rewrite.trade.reports.TechnicalRecordIdRule;
import drr.regulation.asic.rewrite.trade.reports.UnderlyingIdOtherRule;
import drr.regulation.asic.rewrite.trade.reports.UnderlyingIdOtherSourceRule;
import drr.regulation.asic.rewrite.trade.reports.UnderlyingIdentificationRule;
import drr.regulation.asic.rewrite.trade.reports.UnderlyingIdentificationTypeRule;
import drr.regulation.asic.rewrite.trade.reports.UniqueProductIdentifierRule;
import drr.regulation.asic.rewrite.trade.reports.UniqueTransactionIdentifierRule;
import drr.regulation.asic.rewrite.trade.reports.UtiProprietaryRule;
import drr.regulation.asic.rewrite.trade.reports.ValuationAmountRule;
import drr.regulation.asic.rewrite.trade.reports.ValuationCurrencyRule;
import drr.regulation.asic.rewrite.trade.reports.ValuationMethodRule;
import drr.regulation.asic.rewrite.trade.reports.ValuationTimestampRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.link.reports.SecondaryTransactionIdentifierRule;
import drr.regulation.common.trade.party.reports.EntityResponsibleForReportingRule;
import drr.standards.iosco.cde.version3.basket.reports.CustomBasketCodeRule;
import drr.standards.iosco.cde.version3.event.reports.EventIdentifierRule;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.asic.rewrite.trade", body="ASIC", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=ASICTradeLabelProvider.class)
@ImplementedBy(value=ASICTradeReportFunctionDefault.class)
public abstract class ASICTradeReportFunction
implements ReportFunction<TransactionReportInstruction, ASICTransactionReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected AssetClassRule assetClassRule;
    @Inject
    protected BasketConstituentsRule basketConstituentsRule;
    @Inject
    protected BasketStructurerRule basketStructurerRule;
    @Inject
    protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
    @Inject
    protected Beneficiary1Rule beneficiary1Rule;
    @Inject
    protected BrokerRule brokerRule;
    @Inject
    protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
    @Inject
    protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
    @Inject
    protected CallAmountRule callAmountRule;
    @Inject
    protected CallCurrencyRule callCurrencyRule;
    @Inject
    protected CentralCounterpartyRule centralCounterpartyRule;
    @Inject
    protected ClearedRule clearedRule;
    @Inject
    protected ClearingMemberRule clearingMemberRule;
    @Inject
    protected ClearingTimestampRule clearingTimestampRule;
    @Inject
    protected CollateralPortfolioCodeInitialMarginRule collateralPortfolioCodeInitialMarginRule;
    @Inject
    protected CollateralPortfolioCodeVariationMarginRule collateralPortfolioCodeVariationMarginRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected ContractTypeRule contractTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
    @Inject
    protected Counterparty2NameRule counterparty2NameRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
    @Inject
    protected CustomBasketCodeRule customBasketCodeRule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected Direction1Rule direction1Rule;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected EnrichmentDataRule enrichmentDataRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected EventIdentifierRule eventIdentifierRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected ExchangeRateBasisRule exchangeRateBasisRule;
    @Inject
    protected ExchangeRateRule exchangeRateRule;
    @Inject
    protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
    @Inject
    protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected IndexFactorRule indexFactorRule;
    @Inject
    protected Leg1ReportRule leg1ReportRule;
    @Inject
    protected Leg2ReportRule leg2ReportRule;
    @Inject
    protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
    @Inject
    protected NewDerivativeTradeRepositoryRule newDerivativeTradeRepositoryRule;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;
    @Inject
    protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
    @Inject
    protected OtherPaymentRule otherPaymentRule;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PackageTransactionPriceRule packageTransactionPriceRule;
    @Inject
    protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
    @Inject
    protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
    @Inject
    protected PackageTransactionSpreadRule packageTransactionSpreadRule;
    @Inject
    protected PlatformIdentifierRule platformIdentifierRule;
    @Inject
    protected PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
    @Inject
    protected PriorUTIProprietaryRule priorUTIProprietaryRule;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected PutAmountRule putAmountRule;
    @Inject
    protected PutCurrencyRule putCurrencyRule;
    @Inject
    protected ReportSubmittingEntityRule reportSubmittingEntityRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SecondaryTransactionIdentifierRule secondaryTransactionIdentifierRule;
    @Inject
    protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
    @Inject
    protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
    @Inject
    protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceRule strikePriceRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UnderlyingIdOtherRule underlyingIdOtherRule;
    @Inject
    protected UnderlyingIdOtherSourceRule underlyingIdOtherSourceRule;
    @Inject
    protected UnderlyingIdentificationRule underlyingIdentificationRule;
    @Inject
    protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
    @Inject
    protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
    @Inject
    protected UtiProprietaryRule utiProprietaryRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public ASICTransactionReport evaluate(TransactionReportInstruction input) {
        ASICTransactionReport output;
        ASICTransactionReport.ASICTransactionReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(ASICTransactionReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction var1);

    public static class ASICTradeReportFunctionDefault
    extends ASICTradeReportFunction {
        @Override
        protected ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
            ASICTransactionReport.ASICTransactionReportBuilder output = ASICTransactionReport.builder();
            return this.assignOutput(output, input);
        }

        protected ASICTransactionReport.ASICTransactionReportBuilder assignOutput(ASICTransactionReport.ASICTransactionReportBuilder output, TransactionReportInstruction input) {
            output.setEffectiveDate(this.effectiveDateRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setExecutionTimestamp(this.executionTimestampRule.evaluate(input));
            output.setExpirationDate(this.expirationDateRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeIndicatorRule.evaluate(input));
            output.setBeneficiary1(this.beneficiary1Rule.evaluate(input));
            output.setBeneficiary1IdentifierTypeIndicator(this.beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
            output.setCleared(this.clearedRule.evaluate(input));
            output.setCentralCounterparty(this.centralCounterpartyRule.evaluate(input));
            output.setClearingMember(this.clearingMemberRule.evaluate(input));
            output.setCallAmount(this.callAmountRule.evaluate(input));
            output.setPutAmount(this.putAmountRule.evaluate(input));
            output.setCallCurrency(this.callCurrencyRule.evaluate(input));
            output.setPutCurrency(this.putCurrencyRule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setPrice(this.priceRule.evaluate(input));
            output.setPriceNotation(this.priceNotationRule.evaluate(input));
            output.setPriceCurrency(this.priceCurrencyRule.evaluate(input));
            output.setPackageTransactionPrice(this.packageTransactionPriceRule.evaluate(input));
            output.setPackageTransactionPriceNotation(this.packageTransactionPriceNotationRule.evaluate(input));
            output.setPackageTransactionPriceCurrency(this.packageTransactionPriceCurrencyRule.evaluate(input));
            output.setPackageTransactionSpread(this.packageTransactionSpreadRule.evaluate(input));
            output.setPackageTransactionSpreadNotation(this.packageTransactionSpreadNotationRule.evaluate(input));
            output.setPackageTransactionSpreadCurrency(this.packageTransactionSpreadCurrencyRule.evaluate(input));
            output.setPackageIdentifier(this.packageIdentifierRule.evaluate(input));
            output.setStrikePrice(this.strikePriceRule.evaluate(input));
            output.setStrikePriceNotation(this.strikePriceNotationRule.evaluate(input));
            output.setStrikePriceCurrency(this.strikePriceCurrencyCurrencyPairRule.evaluate(input));
            output.setPriceUnitOfMeasure(this.priceUnitOfMeasureRule.evaluate(input));
            output.setOptionPremiumAmount(this.optionPremiumAmountRule.evaluate(input));
            output.setOptionPremiumCurrency(this.optionPremiumCurrencyRule.evaluate(input));
            output.setOptionPremiumPaymentDate(this.optionPremiumPaymentDateRule.evaluate(input));
            output.setExchangeRate(this.exchangeRateRule.evaluate(input));
            output.setExchangeRateBasis(this.exchangeRateBasisRule.evaluate(input));
            output.setCdSIndexAttachmentPoint(this.cDSIndexAttachmentPointRule.evaluate(input));
            output.setCdSIndexDetachmentPoint(this.cDSIndexDetachmentPointRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setPriorUTI(this.priorUTIRule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setCustomBasketCode(this.customBasketCodeRule.evaluate(input));
            output.setBasketConstituents((List)this.basketConstituentsRule.evaluate(input));
            output.setOtherPayment((List)this.otherPaymentRule.evaluate(input));
            output.setLeg1(this.leg1ReportRule.evaluate(input));
            output.setLeg2(this.leg2ReportRule.evaluate(input));
            output.setUnderlyingIdOther(this.underlyingIdOtherRule.evaluate(input));
            output.setUnderlyingIdOtherSource(this.underlyingIdOtherSourceRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventType(this.eventTypeRule.evaluate(input));
            output.setEventIdentifier(this.eventIdentifierRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameRule.evaluate(input));
            output.setExecutionAgentCounterparty1(this.executionAgentCounterparty1Rule.evaluate(input));
            output.setExecutionAgentCounterparty2(this.executionAgentCounterparty2DTCCRule.evaluate(input));
            output.setReportSubmittingEntityID(this.reportSubmittingEntityRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.utiProprietaryRule.evaluate(input));
            output.setPriorUTIProprietary(this.priorUTIProprietaryRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setContractTypeOverriddenAsCommonContractType(this.contractTypeRule.evaluate(input));
            output.setAssetClassOverriddenAsCommonAssetClass(this.assetClassRule.evaluate(input));
            output.setClearingTimestamp(this.clearingTimestampRule.evaluate(input));
            output.setPlatformIdentifier(this.platformIdentifierRule.evaluate(input));
            output.setDirection1(this.direction1Rule.evaluate(input));
            output.setBarrier(this.singleOrUpperAndLowerBarrierRule.evaluate(input));
            output.setMaturityDateOfTheUnderlying(this.maturityDateOfTheUnderlierRule.evaluate(input));
            output.setCountryOfTheCounterparty2(this.countryOfCounterparty2Rule.evaluate(input));
            output.setIndexFactor(this.indexFactorRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.collateralPortfolioCodeInitialMarginRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.collateralPortfolioCodeVariationMarginRule.evaluate(input));
            output.setBrokerID(this.brokerRule.evaluate(input));
            output.setSecondaryTransactionIdentifier(this.secondaryTransactionIdentifierRule.evaluate(input));
            output.setEntityResponsibleForReporting(this.entityResponsibleForReportingRule.evaluate(input));
            output.setUnderlyingIdentification(this.underlyingIdentificationRule.evaluate(input));
            output.setUnderlyingIdentificationType(this.underlyingIdentificationTypeRule.evaluate(input));
            output.getOrCreateNonReportable().setEnrichment(this.enrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPreUpiData(this.upiPreEnrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPostUpiData(this.upiPostEnrichmentDataRule.evaluate(input));
            output.setBasketStructurerID(this.basketStructurerRule.evaluate(input));
            output.setNewDerivativeTradeRepository(this.newDerivativeTradeRepositoryRule.evaluate(input));
            output.setSmallScaleBuySideEntityIndicator(this.smallScaleBuySideEntityIndicatorRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

