/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.version2.payment.reports.DayCountConventionRule;
import drr.standards.iso.InterestComputationMethod4Code;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateDayCountConventionLeg1RuleDefault.class)
public abstract class FloatingRateDayCountConventionLeg1Rule
implements ReportFunction<TransactionReportInstruction, InterestComputationMethod4Code> {
    @Inject
    protected DayCountConventionRule dayCountConventionRule;
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;

    public InterestComputationMethod4Code evaluate(TransactionReportInstruction input) {
        InterestComputationMethod4Code output = this.doEvaluate(input);
        return output;
    }

    protected abstract InterestComputationMethod4Code doEvaluate(TransactionReportInstruction var1);

    public static class FloatingRateDayCountConventionLeg1RuleDefault
    extends FloatingRateDayCountConventionLeg1Rule {
        @Override
        protected InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input) {
            InterestComputationMethod4Code output = null;
            return this.assignOutput(output, input);
        }

        protected InterestComputationMethod4Code assignOutput(InterestComputationMethod4Code output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> MapperS.of((Object)this.interestRateLeg1.evaluate((Product)item.get())));
            MapperS thenArg4 = thenArg3.filterSingleNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
            output = (InterestComputationMethod4Code)((Object)thenArg4.mapSingleToItem(item -> MapperS.of((Object)((Object)this.dayCountConventionRule.evaluate((InterestRatePayout)item.get())))).get());
            return output;
        }
    }
}

