/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart45Leg;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CFTCPart45LegTypeFormatValidator
implements Validator<CFTCPart45Leg> {
    private List<ComparisonResult> getComparisonResults(CFTCPart45Leg o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkNumber((String)"notionalAmount", (BigDecimal)o.getNotionalAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"totalNotionalQuantity", (BigDecimal)o.getTotalNotionalQuantity(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"fixedRate", (BigDecimal)o.getFixedRate(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"quantityUnitOfMeasure", (String)o.getQuantityUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperators.checkNumber((String)"notionalQuantity", (BigDecimal)o.getNotionalQuantity(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"quantityFrequencyMultiplier", (Integer)o.getQuantityFrequencyMultiplier(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"payerIdentifier", (String)o.getPayerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"receiverIdentifier", (String)o.getReceiverIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45Leg o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CFTCPart45Leg", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCPart45Leg", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CFTCPart45Leg", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCPart45Leg", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

