/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.dtcc;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.dtcc.ProductGradeReport;
import drr.regulation.common.dtcc.meta.CommonDTCCAdditionalFieldsMeta;
import drr.standards.iso.OptionStyleEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommonDTCCAdditionalFields", builder=CommonDTCCAdditionalFieldsBuilderImpl.class, version="6.17.7")
@RuneDataType(value="CommonDTCCAdditionalFields", model="drr", builder=CommonDTCCAdditionalFieldsBuilderImpl.class, version="6.17.7")
public interface CommonDTCCAdditionalFields
extends RosettaModelObject {
    public static final CommonDTCCAdditionalFieldsMeta metaData = new CommonDTCCAdditionalFieldsMeta();

    public PartyIdentifierTypeEnum getClearingVenueIDType();

    public PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType();

    public PartyIdentifierTypeEnum getSubmittingPartyIDType();

    public String getSubmittedForParty();

    public String getTradeLegTypes();

    public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();

    public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination();

    public AssetClassEnum getPrimaryAssetClass();

    public AssetClassEnum getSecondaryAssetClass();

    public String getComment1();

    public OptionStyleEnum getOptionStyle();

    public String getOptionType();

    public String getProductID();

    public String getTradeParty2ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType();

    public String getTradeParty1ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType();

    public String getTradeParty1TransactionID();

    public String getSettlementType();

    public List<? extends ProductGradeReport> getProductGrade();

    public String getDeliveryLocation();

    public String getLeg1CommodityInstrumentID();

    public String getLeg2CommodityInstrumentID();

    public PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType();

    public String getResponsibleDataSubmitterID();

    public Date getMaturityDateOfTheUnderlying();

    public String getCorporateActionNewTradeParty1Lei();

    public List<String> getOtherPaymentPayerIDType();

    public List<String> getOtherPaymentReceiverIDType();

    public CommonDTCCAdditionalFields build();

    public CommonDTCCAdditionalFieldsBuilder toBuilder();

    public static CommonDTCCAdditionalFieldsBuilder builder() {
        return new CommonDTCCAdditionalFieldsBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonDTCCAdditionalFields> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonDTCCAdditionalFields> getType() {
        return CommonDTCCAdditionalFields.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.class, this.getProductGrade(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonDTCCAdditionalFieldsBuilderImpl
    implements CommonDTCCAdditionalFieldsBuilder {
        protected PartyIdentifierTypeEnum clearingVenueIDType;
        protected PartyIdentifierTypeEnum tradeParty1ClearingBrokerIDType;
        protected PartyIdentifierTypeEnum submittingPartyIDType;
        protected String submittedForParty;
        protected String tradeLegTypes;
        protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected List<SupervisoryBodyEnum> tradeParty2ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected AssetClassEnum primaryAssetClass;
        protected AssetClassEnum secondaryAssetClass;
        protected String comment1;
        protected OptionStyleEnum optionStyle;
        protected String optionType;
        protected String productID;
        protected String tradeParty2ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        protected String tradeParty1ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        protected String tradeParty1TransactionID;
        protected String settlementType;
        protected List<ProductGradeReport.ProductGradeReportBuilder> productGrade = new ArrayList<ProductGradeReport.ProductGradeReportBuilder>();
        protected String deliveryLocation;
        protected String leg1CommodityInstrumentID;
        protected String leg2CommodityInstrumentID;
        protected PartyIdentifierTypeEnum responsibleDataSubmitterIDType;
        protected String responsibleDataSubmitterID;
        protected Date maturityDateOfTheUnderlying;
        protected String corporateActionNewTradeParty1Lei;
        protected List<String> otherPaymentPayerIDType = new ArrayList<String>();
        protected List<String> otherPaymentReceiverIDType = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="clearingVenueIDType")
        @RuneAttribute(value="clearingVenueIDType")
        public PartyIdentifierTypeEnum getClearingVenueIDType() {
            return this.clearingVenueIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ClearingBrokerIDType")
        @RuneAttribute(value="tradeParty1ClearingBrokerIDType")
        public PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType() {
            return this.tradeParty1ClearingBrokerIDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeLegTypes")
        @RuneAttribute(value="tradeLegTypes")
        public String getTradeLegTypes() {
            return this.tradeLegTypes;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public AssetClassEnum getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public OptionStyleEnum getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="productID")
        @RuneAttribute(value="productID")
        public String getProductID() {
            return this.productID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public String getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="productGrade")
        @RuneAttribute(value="productGrade")
        public List<? extends ProductGradeReport.ProductGradeReportBuilder> getProductGrade() {
            return this.productGrade;
        }

        @Override
        public ProductGradeReport.ProductGradeReportBuilder getOrCreateProductGrade(int index) {
            if (this.productGrade == null) {
                this.productGrade = new ArrayList<ProductGradeReport.ProductGradeReportBuilder>();
            }
            return (ProductGradeReport.ProductGradeReportBuilder)this.getIndex(this.productGrade, index, () -> {
                ProductGradeReport.ProductGradeReportBuilder newProductGrade = ProductGradeReport.builder();
                return newProductGrade;
            });
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public String getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityInstrumentID")
        @RuneAttribute(value="leg1CommodityInstrumentID")
        public String getLeg1CommodityInstrumentID() {
            return this.leg1CommodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityInstrumentID")
        @RuneAttribute(value="leg2CommodityInstrumentID")
        public String getLeg2CommodityInstrumentID() {
            return this.leg2CommodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterIDType")
        @RuneAttribute(value="responsibleDataSubmitterIDType")
        public PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType() {
            return this.responsibleDataSubmitterIDType;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterID")
        @RuneAttribute(value="responsibleDataSubmitterID")
        public String getResponsibleDataSubmitterID() {
            return this.responsibleDataSubmitterID;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="corporateActionNewTradeParty1Lei")
        @RuneAttribute(value="corporateActionNewTradeParty1Lei")
        public String getCorporateActionNewTradeParty1Lei() {
            return this.corporateActionNewTradeParty1Lei;
        }

        @Override
        @RosettaAttribute(value="otherPaymentPayerIDType")
        @RuneAttribute(value="otherPaymentPayerIDType")
        public List<String> getOtherPaymentPayerIDType() {
            return this.otherPaymentPayerIDType;
        }

        @Override
        @RosettaAttribute(value="otherPaymentReceiverIDType")
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public List<String> getOtherPaymentReceiverIDType() {
            return this.otherPaymentReceiverIDType;
        }

        @Override
        @RosettaAttribute(value="clearingVenueIDType")
        @RuneAttribute(value="clearingVenueIDType")
        public CommonDTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum _clearingVenueIDType) {
            this.clearingVenueIDType = _clearingVenueIDType == null ? null : _clearingVenueIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ClearingBrokerIDType")
        @RuneAttribute(value="tradeParty1ClearingBrokerIDType")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum _tradeParty1ClearingBrokerIDType) {
            this.tradeParty1ClearingBrokerIDType = _tradeParty1ClearingBrokerIDType == null ? null : _tradeParty1ClearingBrokerIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public CommonDTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public CommonDTCCAdditionalFieldsBuilder setSubmittedForParty(String _submittedForParty) {
            this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeLegTypes")
        @RuneAttribute(value="tradeLegTypes")
        public CommonDTCCAdditionalFieldsBuilder setTradeLegTypes(String _tradeLegTypes) {
            this.tradeLegTypes = _tradeLegTypes == null ? null : _tradeLegTypes;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
            if (_tradeParty2ReportingDestination != null) {
                this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
            }
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int idx) {
            this.getIndex(this.tradeParty2ReportingDestination, idx, () -> _tradeParty2ReportingDestination);
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            if (tradeParty2ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
                    this.tradeParty2ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty2ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public CommonDTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public CommonDTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum _secondaryAssetClass) {
            this.secondaryAssetClass = _secondaryAssetClass == null ? null : _secondaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public CommonDTCCAdditionalFieldsBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public CommonDTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public CommonDTCCAdditionalFieldsBuilder setOptionType(String _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productID")
        @RuneAttribute(value="productID")
        public CommonDTCCAdditionalFieldsBuilder setProductID(String _productID) {
            this.productID = _productID == null ? null : _productID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
            this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
            this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
            this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
            this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public CommonDTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
            this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public CommonDTCCAdditionalFieldsBuilder setSettlementType(String _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productGrade")
        @RuneAttribute(value="productGrade")
        public CommonDTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade) {
            if (_productGrade != null) {
                this.productGrade.add(_productGrade.toBuilder());
            }
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade, int idx) {
            this.getIndex(this.productGrade, idx, () -> _productGrade.toBuilder());
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> productGrades) {
            if (productGrades != null) {
                for (ProductGradeReport productGradeReport : productGrades) {
                    this.productGrade.add(productGradeReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productGrade")
        public CommonDTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> productGrades) {
            this.productGrade = productGrades == null ? new ArrayList<ProductGradeReport.ProductGradeReportBuilder>() : (List)productGrades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public CommonDTCCAdditionalFieldsBuilder setDeliveryLocation(String _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityInstrumentID")
        @RuneAttribute(value="leg1CommodityInstrumentID")
        public CommonDTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String _leg1CommodityInstrumentID) {
            this.leg1CommodityInstrumentID = _leg1CommodityInstrumentID == null ? null : _leg1CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityInstrumentID")
        @RuneAttribute(value="leg2CommodityInstrumentID")
        public CommonDTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String _leg2CommodityInstrumentID) {
            this.leg2CommodityInstrumentID = _leg2CommodityInstrumentID == null ? null : _leg2CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterIDType")
        @RuneAttribute(value="responsibleDataSubmitterIDType")
        public CommonDTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum _responsibleDataSubmitterIDType) {
            this.responsibleDataSubmitterIDType = _responsibleDataSubmitterIDType == null ? null : _responsibleDataSubmitterIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterID")
        @RuneAttribute(value="responsibleDataSubmitterID")
        public CommonDTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String _responsibleDataSubmitterID) {
            this.responsibleDataSubmitterID = _responsibleDataSubmitterID == null ? null : _responsibleDataSubmitterID;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public CommonDTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionNewTradeParty1Lei")
        @RuneAttribute(value="corporateActionNewTradeParty1Lei")
        public CommonDTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String _corporateActionNewTradeParty1Lei) {
            this.corporateActionNewTradeParty1Lei = _corporateActionNewTradeParty1Lei == null ? null : _corporateActionNewTradeParty1Lei;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentPayerIDType")
        @RuneAttribute(value="otherPaymentPayerIDType")
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType) {
            if (_otherPaymentPayerIDType != null) {
                this.otherPaymentPayerIDType.add(_otherPaymentPayerIDType);
            }
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType, int idx) {
            this.getIndex(this.otherPaymentPayerIDType, idx, () -> _otherPaymentPayerIDType);
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            if (otherPaymentPayerIDTypes != null) {
                for (String toAdd : otherPaymentPayerIDTypes) {
                    this.otherPaymentPayerIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentPayerIDType")
        public CommonDTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            this.otherPaymentPayerIDType = otherPaymentPayerIDTypes == null ? new ArrayList<String>() : (List)otherPaymentPayerIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentReceiverIDType")
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType) {
            if (_otherPaymentReceiverIDType != null) {
                this.otherPaymentReceiverIDType.add(_otherPaymentReceiverIDType);
            }
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType, int idx) {
            this.getIndex(this.otherPaymentReceiverIDType, idx, () -> _otherPaymentReceiverIDType);
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            if (otherPaymentReceiverIDTypes != null) {
                for (String toAdd : otherPaymentReceiverIDTypes) {
                    this.otherPaymentReceiverIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public CommonDTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            this.otherPaymentReceiverIDType = otherPaymentReceiverIDTypes == null ? new ArrayList<String>() : (List)otherPaymentReceiverIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CommonDTCCAdditionalFields build() {
            return new CommonDTCCAdditionalFieldsImpl(this);
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder prune() {
            this.productGrade = this.productGrade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getClearingVenueIDType() != null) {
                return true;
            }
            if (this.getTradeParty1ClearingBrokerIDType() != null) {
                return true;
            }
            if (this.getSubmittingPartyIDType() != null) {
                return true;
            }
            if (this.getSubmittedForParty() != null) {
                return true;
            }
            if (this.getTradeLegTypes() != null) {
                return true;
            }
            if (this.getTradeParty1ReportingDestination() != null && !this.getTradeParty1ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getTradeParty2ReportingDestination() != null && !this.getTradeParty2ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getPrimaryAssetClass() != null) {
                return true;
            }
            if (this.getSecondaryAssetClass() != null) {
                return true;
            }
            if (this.getComment1() != null) {
                return true;
            }
            if (this.getOptionStyle() != null) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getProductID() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1TransactionID() != null) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getProductGrade() != null && this.getProductGrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDeliveryLocation() != null) {
                return true;
            }
            if (this.getLeg1CommodityInstrumentID() != null) {
                return true;
            }
            if (this.getLeg2CommodityInstrumentID() != null) {
                return true;
            }
            if (this.getResponsibleDataSubmitterIDType() != null) {
                return true;
            }
            if (this.getResponsibleDataSubmitterID() != null) {
                return true;
            }
            if (this.getMaturityDateOfTheUnderlying() != null) {
                return true;
            }
            if (this.getCorporateActionNewTradeParty1Lei() != null) {
                return true;
            }
            if (this.getOtherPaymentPayerIDType() != null && !this.getOtherPaymentPayerIDType().isEmpty()) {
                return true;
            }
            return this.getOtherPaymentReceiverIDType() != null && !this.getOtherPaymentReceiverIDType().isEmpty();
        }

        public CommonDTCCAdditionalFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommonDTCCAdditionalFieldsBuilder o = (CommonDTCCAdditionalFieldsBuilder)other;
            merger.mergeRosetta(this.getProductGrade(), o.getProductGrade(), this::getOrCreateProductGrade);
            merger.mergeBasic((Object)this.getClearingVenueIDType(), (Object)o.getClearingVenueIDType(), this::setClearingVenueIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ClearingBrokerIDType(), (Object)o.getTradeParty1ClearingBrokerIDType(), this::setTradeParty1ClearingBrokerIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittingPartyIDType(), (Object)o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittedForParty(), (Object)o.getSubmittedForParty(), this::setSubmittedForParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeLegTypes(), (Object)o.getTradeLegTypes(), this::setTradeLegTypes, new AttributeMeta[0]);
            merger.mergeBasic(this.getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), this::addTradeParty1ReportingDestination);
            merger.mergeBasic(this.getTradeParty2ReportingDestination(), o.getTradeParty2ReportingDestination(), this::addTradeParty2ReportingDestination);
            merger.mergeBasic((Object)this.getPrimaryAssetClass(), (Object)o.getPrimaryAssetClass(), this::setPrimaryAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecondaryAssetClass(), (Object)o.getSecondaryAssetClass(), this::setSecondaryAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getComment1(), (Object)o.getComment1(), this::setComment1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionStyle(), (Object)o.getOptionStyle(), this::setOptionStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getProductID(), (Object)o.getProductID(), this::setProductID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentID(), (Object)o.getTradeParty2ExecutionAgentID(), this::setTradeParty2ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentIDType(), (Object)o.getTradeParty2ExecutionAgentIDType(), this::setTradeParty2ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentID(), (Object)o.getTradeParty1ExecutionAgentID(), this::setTradeParty1ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentIDType(), (Object)o.getTradeParty1ExecutionAgentIDType(), this::setTradeParty1ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1TransactionID(), (Object)o.getTradeParty1TransactionID(), this::setTradeParty1TransactionID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryLocation(), (Object)o.getDeliveryLocation(), this::setDeliveryLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg1CommodityInstrumentID(), (Object)o.getLeg1CommodityInstrumentID(), this::setLeg1CommodityInstrumentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg2CommodityInstrumentID(), (Object)o.getLeg2CommodityInstrumentID(), this::setLeg2CommodityInstrumentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResponsibleDataSubmitterIDType(), (Object)o.getResponsibleDataSubmitterIDType(), this::setResponsibleDataSubmitterIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResponsibleDataSubmitterID(), (Object)o.getResponsibleDataSubmitterID(), this::setResponsibleDataSubmitterID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDateOfTheUnderlying(), (Object)o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCorporateActionNewTradeParty1Lei(), (Object)o.getCorporateActionNewTradeParty1Lei(), this::setCorporateActionNewTradeParty1Lei, new AttributeMeta[0]);
            merger.mergeBasic(this.getOtherPaymentPayerIDType(), o.getOtherPaymentPayerIDType(), this::addOtherPaymentPayerIDType);
            merger.mergeBasic(this.getOtherPaymentReceiverIDType(), o.getOtherPaymentReceiverIDType(), this::addOtherPaymentReceiverIDType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommonDTCCAdditionalFields _that = this.getType().cast(o);
            if (!Objects.equals(this.clearingVenueIDType, _that.getClearingVenueIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ClearingBrokerIDType, _that.getTradeParty1ClearingBrokerIDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!Objects.equals(this.tradeLegTypes, _that.getTradeLegTypes())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.secondaryAssetClass, _that.getSecondaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionStyle, (Object)_that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.productID, _that.getProductID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            if (!Objects.equals(this.settlementType, _that.getSettlementType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productGrade, _that.getProductGrade())) {
                return false;
            }
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityInstrumentID, _that.getLeg1CommodityInstrumentID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityInstrumentID, _that.getLeg2CommodityInstrumentID())) {
                return false;
            }
            if (!Objects.equals(this.responsibleDataSubmitterIDType, _that.getResponsibleDataSubmitterIDType())) {
                return false;
            }
            if (!Objects.equals(this.responsibleDataSubmitterID, _that.getResponsibleDataSubmitterID())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.corporateActionNewTradeParty1Lei, _that.getCorporateActionNewTradeParty1Lei())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPaymentPayerIDType, _that.getOtherPaymentPayerIDType())) {
                return false;
            }
            return ListEquals.listEquals(this.otherPaymentReceiverIDType, _that.getOtherPaymentReceiverIDType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.clearingVenueIDType != null ? this.clearingVenueIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ClearingBrokerIDType != null ? this.tradeParty1ClearingBrokerIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeLegTypes != null ? this.tradeLegTypes.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? ((Object)((Object)this.optionStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.productID != null ? this.productID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? this.settlementType.hashCode() : 0);
            _result = 31 * _result + (this.productGrade != null ? this.productGrade.hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityInstrumentID != null ? this.leg1CommodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityInstrumentID != null ? this.leg2CommodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.responsibleDataSubmitterIDType != null ? this.responsibleDataSubmitterIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.responsibleDataSubmitterID != null ? this.responsibleDataSubmitterID.hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.corporateActionNewTradeParty1Lei != null ? this.corporateActionNewTradeParty1Lei.hashCode() : 0);
            _result = 31 * _result + (this.otherPaymentPayerIDType != null ? this.otherPaymentPayerIDType.hashCode() : 0);
            _result = 31 * _result + (this.otherPaymentReceiverIDType != null ? this.otherPaymentReceiverIDType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommonDTCCAdditionalFieldsBuilder {clearingVenueIDType=" + String.valueOf(this.clearingVenueIDType) + ", tradeParty1ClearingBrokerIDType=" + String.valueOf(this.tradeParty1ClearingBrokerIDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", submittedForParty=" + this.submittedForParty + ", tradeLegTypes=" + this.tradeLegTypes + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", secondaryAssetClass=" + String.valueOf(this.secondaryAssetClass) + ", comment1=" + this.comment1 + ", optionStyle=" + String.valueOf((Object)this.optionStyle) + ", optionType=" + this.optionType + ", productID=" + this.productID + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", settlementType=" + this.settlementType + ", productGrade=" + String.valueOf(this.productGrade) + ", deliveryLocation=" + this.deliveryLocation + ", leg1CommodityInstrumentID=" + this.leg1CommodityInstrumentID + ", leg2CommodityInstrumentID=" + this.leg2CommodityInstrumentID + ", responsibleDataSubmitterIDType=" + String.valueOf(this.responsibleDataSubmitterIDType) + ", responsibleDataSubmitterID=" + this.responsibleDataSubmitterID + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", corporateActionNewTradeParty1Lei=" + this.corporateActionNewTradeParty1Lei + ", otherPaymentPayerIDType=" + String.valueOf(this.otherPaymentPayerIDType) + ", otherPaymentReceiverIDType=" + String.valueOf(this.otherPaymentReceiverIDType) + "}";
        }
    }

    public static interface CommonDTCCAdditionalFieldsBuilder
    extends CommonDTCCAdditionalFields,
    RosettaModelObjectBuilder {
        public ProductGradeReport.ProductGradeReportBuilder getOrCreateProductGrade(int var1);

        public List<? extends ProductGradeReport.ProductGradeReportBuilder> getProductGrade();

        public CommonDTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setSubmittedForParty(String var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeLegTypes(String var1);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CommonDTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CommonDTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setComment1(String var1);

        public CommonDTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setOptionType(String var1);

        public CommonDTCCAdditionalFieldsBuilder setProductID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setSettlementType(String var1);

        public CommonDTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1);

        public CommonDTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1, int var2);

        public CommonDTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> var1);

        public CommonDTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> var1);

        public CommonDTCCAdditionalFieldsBuilder setDeliveryLocation(String var1);

        public CommonDTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum var1);

        public CommonDTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String var1);

        public CommonDTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date var1);

        public CommonDTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String var1);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1, int var2);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> var1);

        public CommonDTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> var1);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1, int var2);

        public CommonDTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> var1);

        public CommonDTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.ProductGradeReportBuilder.class, this.getProductGrade(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommonDTCCAdditionalFieldsBuilder prune();
    }

    public static class CommonDTCCAdditionalFieldsImpl
    implements CommonDTCCAdditionalFields {
        private final PartyIdentifierTypeEnum clearingVenueIDType;
        private final PartyIdentifierTypeEnum tradeParty1ClearingBrokerIDType;
        private final PartyIdentifierTypeEnum submittingPartyIDType;
        private final String submittedForParty;
        private final String tradeLegTypes;
        private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
        private final List<SupervisoryBodyEnum> tradeParty2ReportingDestination;
        private final AssetClassEnum primaryAssetClass;
        private final AssetClassEnum secondaryAssetClass;
        private final String comment1;
        private final OptionStyleEnum optionStyle;
        private final String optionType;
        private final String productID;
        private final String tradeParty2ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        private final String tradeParty1ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        private final String tradeParty1TransactionID;
        private final String settlementType;
        private final List<? extends ProductGradeReport> productGrade;
        private final String deliveryLocation;
        private final String leg1CommodityInstrumentID;
        private final String leg2CommodityInstrumentID;
        private final PartyIdentifierTypeEnum responsibleDataSubmitterIDType;
        private final String responsibleDataSubmitterID;
        private final Date maturityDateOfTheUnderlying;
        private final String corporateActionNewTradeParty1Lei;
        private final List<String> otherPaymentPayerIDType;
        private final List<String> otherPaymentReceiverIDType;

        protected CommonDTCCAdditionalFieldsImpl(CommonDTCCAdditionalFieldsBuilder builder) {
            this.clearingVenueIDType = builder.getClearingVenueIDType();
            this.tradeParty1ClearingBrokerIDType = builder.getTradeParty1ClearingBrokerIDType();
            this.submittingPartyIDType = builder.getSubmittingPartyIDType();
            this.submittedForParty = builder.getSubmittedForParty();
            this.tradeLegTypes = builder.getTradeLegTypes();
            this.tradeParty1ReportingDestination = Optional.ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.tradeParty2ReportingDestination = Optional.ofNullable(builder.getTradeParty2ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.primaryAssetClass = builder.getPrimaryAssetClass();
            this.secondaryAssetClass = builder.getSecondaryAssetClass();
            this.comment1 = builder.getComment1();
            this.optionStyle = builder.getOptionStyle();
            this.optionType = builder.getOptionType();
            this.productID = builder.getProductID();
            this.tradeParty2ExecutionAgentID = builder.getTradeParty2ExecutionAgentID();
            this.tradeParty2ExecutionAgentIDType = builder.getTradeParty2ExecutionAgentIDType();
            this.tradeParty1ExecutionAgentID = builder.getTradeParty1ExecutionAgentID();
            this.tradeParty1ExecutionAgentIDType = builder.getTradeParty1ExecutionAgentIDType();
            this.tradeParty1TransactionID = builder.getTradeParty1TransactionID();
            this.settlementType = builder.getSettlementType();
            this.productGrade = Optional.ofNullable(builder.getProductGrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.deliveryLocation = builder.getDeliveryLocation();
            this.leg1CommodityInstrumentID = builder.getLeg1CommodityInstrumentID();
            this.leg2CommodityInstrumentID = builder.getLeg2CommodityInstrumentID();
            this.responsibleDataSubmitterIDType = builder.getResponsibleDataSubmitterIDType();
            this.responsibleDataSubmitterID = builder.getResponsibleDataSubmitterID();
            this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
            this.corporateActionNewTradeParty1Lei = builder.getCorporateActionNewTradeParty1Lei();
            this.otherPaymentPayerIDType = Optional.ofNullable(builder.getOtherPaymentPayerIDType()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.otherPaymentReceiverIDType = Optional.ofNullable(builder.getOtherPaymentReceiverIDType()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="clearingVenueIDType")
        @RuneAttribute(value="clearingVenueIDType")
        public PartyIdentifierTypeEnum getClearingVenueIDType() {
            return this.clearingVenueIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ClearingBrokerIDType")
        @RuneAttribute(value="tradeParty1ClearingBrokerIDType")
        public PartyIdentifierTypeEnum getTradeParty1ClearingBrokerIDType() {
            return this.tradeParty1ClearingBrokerIDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeLegTypes")
        @RuneAttribute(value="tradeLegTypes")
        public String getTradeLegTypes() {
            return this.tradeLegTypes;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public AssetClassEnum getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public OptionStyleEnum getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public String getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="productID")
        @RuneAttribute(value="productID")
        public String getProductID() {
            return this.productID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public String getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="productGrade")
        @RuneAttribute(value="productGrade")
        public List<? extends ProductGradeReport> getProductGrade() {
            return this.productGrade;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public String getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityInstrumentID")
        @RuneAttribute(value="leg1CommodityInstrumentID")
        public String getLeg1CommodityInstrumentID() {
            return this.leg1CommodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityInstrumentID")
        @RuneAttribute(value="leg2CommodityInstrumentID")
        public String getLeg2CommodityInstrumentID() {
            return this.leg2CommodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterIDType")
        @RuneAttribute(value="responsibleDataSubmitterIDType")
        public PartyIdentifierTypeEnum getResponsibleDataSubmitterIDType() {
            return this.responsibleDataSubmitterIDType;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterID")
        @RuneAttribute(value="responsibleDataSubmitterID")
        public String getResponsibleDataSubmitterID() {
            return this.responsibleDataSubmitterID;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="corporateActionNewTradeParty1Lei")
        @RuneAttribute(value="corporateActionNewTradeParty1Lei")
        public String getCorporateActionNewTradeParty1Lei() {
            return this.corporateActionNewTradeParty1Lei;
        }

        @Override
        @RosettaAttribute(value="otherPaymentPayerIDType")
        @RuneAttribute(value="otherPaymentPayerIDType")
        public List<String> getOtherPaymentPayerIDType() {
            return this.otherPaymentPayerIDType;
        }

        @Override
        @RosettaAttribute(value="otherPaymentReceiverIDType")
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public List<String> getOtherPaymentReceiverIDType() {
            return this.otherPaymentReceiverIDType;
        }

        @Override
        public CommonDTCCAdditionalFields build() {
            return this;
        }

        @Override
        public CommonDTCCAdditionalFieldsBuilder toBuilder() {
            CommonDTCCAdditionalFieldsBuilder builder = CommonDTCCAdditionalFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonDTCCAdditionalFieldsBuilder builder) {
            Optional.ofNullable(this.getClearingVenueIDType()).ifPresent(builder::setClearingVenueIDType);
            Optional.ofNullable(this.getTradeParty1ClearingBrokerIDType()).ifPresent(builder::setTradeParty1ClearingBrokerIDType);
            Optional.ofNullable(this.getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
            Optional.ofNullable(this.getSubmittedForParty()).ifPresent(builder::setSubmittedForParty);
            Optional.ofNullable(this.getTradeLegTypes()).ifPresent(builder::setTradeLegTypes);
            Optional.ofNullable(this.getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
            Optional.ofNullable(this.getTradeParty2ReportingDestination()).ifPresent(builder::setTradeParty2ReportingDestination);
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
            Optional.ofNullable(this.getComment1()).ifPresent(builder::setComment1);
            Optional.ofNullable(this.getOptionStyle()).ifPresent(builder::setOptionStyle);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getProductID()).ifPresent(builder::setProductID);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentID()).ifPresent(builder::setTradeParty2ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentIDType()).ifPresent(builder::setTradeParty2ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentID()).ifPresent(builder::setTradeParty1ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentIDType()).ifPresent(builder::setTradeParty1ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1TransactionID()).ifPresent(builder::setTradeParty1TransactionID);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getProductGrade()).ifPresent(builder::setProductGrade);
            Optional.ofNullable(this.getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
            Optional.ofNullable(this.getLeg1CommodityInstrumentID()).ifPresent(builder::setLeg1CommodityInstrumentID);
            Optional.ofNullable(this.getLeg2CommodityInstrumentID()).ifPresent(builder::setLeg2CommodityInstrumentID);
            Optional.ofNullable(this.getResponsibleDataSubmitterIDType()).ifPresent(builder::setResponsibleDataSubmitterIDType);
            Optional.ofNullable(this.getResponsibleDataSubmitterID()).ifPresent(builder::setResponsibleDataSubmitterID);
            Optional.ofNullable(this.getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
            Optional.ofNullable(this.getCorporateActionNewTradeParty1Lei()).ifPresent(builder::setCorporateActionNewTradeParty1Lei);
            Optional.ofNullable(this.getOtherPaymentPayerIDType()).ifPresent(builder::setOtherPaymentPayerIDType);
            Optional.ofNullable(this.getOtherPaymentReceiverIDType()).ifPresent(builder::setOtherPaymentReceiverIDType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommonDTCCAdditionalFields _that = this.getType().cast(o);
            if (!Objects.equals(this.clearingVenueIDType, _that.getClearingVenueIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ClearingBrokerIDType, _that.getTradeParty1ClearingBrokerIDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!Objects.equals(this.tradeLegTypes, _that.getTradeLegTypes())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.secondaryAssetClass, _that.getSecondaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionStyle, (Object)_that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.productID, _that.getProductID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            if (!Objects.equals(this.settlementType, _that.getSettlementType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productGrade, _that.getProductGrade())) {
                return false;
            }
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityInstrumentID, _that.getLeg1CommodityInstrumentID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityInstrumentID, _that.getLeg2CommodityInstrumentID())) {
                return false;
            }
            if (!Objects.equals(this.responsibleDataSubmitterIDType, _that.getResponsibleDataSubmitterIDType())) {
                return false;
            }
            if (!Objects.equals(this.responsibleDataSubmitterID, _that.getResponsibleDataSubmitterID())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.corporateActionNewTradeParty1Lei, _that.getCorporateActionNewTradeParty1Lei())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPaymentPayerIDType, _that.getOtherPaymentPayerIDType())) {
                return false;
            }
            return ListEquals.listEquals(this.otherPaymentReceiverIDType, _that.getOtherPaymentReceiverIDType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.clearingVenueIDType != null ? this.clearingVenueIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ClearingBrokerIDType != null ? this.tradeParty1ClearingBrokerIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeLegTypes != null ? this.tradeLegTypes.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? ((Object)((Object)this.optionStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.productID != null ? this.productID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? this.settlementType.hashCode() : 0);
            _result = 31 * _result + (this.productGrade != null ? this.productGrade.hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityInstrumentID != null ? this.leg1CommodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityInstrumentID != null ? this.leg2CommodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.responsibleDataSubmitterIDType != null ? this.responsibleDataSubmitterIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.responsibleDataSubmitterID != null ? this.responsibleDataSubmitterID.hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.corporateActionNewTradeParty1Lei != null ? this.corporateActionNewTradeParty1Lei.hashCode() : 0);
            _result = 31 * _result + (this.otherPaymentPayerIDType != null ? this.otherPaymentPayerIDType.hashCode() : 0);
            _result = 31 * _result + (this.otherPaymentReceiverIDType != null ? this.otherPaymentReceiverIDType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommonDTCCAdditionalFields {clearingVenueIDType=" + String.valueOf(this.clearingVenueIDType) + ", tradeParty1ClearingBrokerIDType=" + String.valueOf(this.tradeParty1ClearingBrokerIDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", submittedForParty=" + this.submittedForParty + ", tradeLegTypes=" + this.tradeLegTypes + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", secondaryAssetClass=" + String.valueOf(this.secondaryAssetClass) + ", comment1=" + this.comment1 + ", optionStyle=" + String.valueOf((Object)this.optionStyle) + ", optionType=" + this.optionType + ", productID=" + this.productID + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", settlementType=" + this.settlementType + ", productGrade=" + String.valueOf(this.productGrade) + ", deliveryLocation=" + this.deliveryLocation + ", leg1CommodityInstrumentID=" + this.leg1CommodityInstrumentID + ", leg2CommodityInstrumentID=" + this.leg2CommodityInstrumentID + ", responsibleDataSubmitterIDType=" + String.valueOf(this.responsibleDataSubmitterIDType) + ", responsibleDataSubmitterID=" + this.responsibleDataSubmitterID + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", corporateActionNewTradeParty1Lei=" + this.corporateActionNewTradeParty1Lei + ", otherPaymentPayerIDType=" + String.valueOf(this.otherPaymentPayerIDType) + ", otherPaymentReceiverIDType=" + String.valueOf(this.otherPaymentReceiverIDType) + "}";
        }
    }
}

