/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.GetQuantityKeys;
import drr.regulation.common.functions.GetQuantityReference;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityObservablePriceQuantityDefault.class)
public abstract class CommodityObservablePriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetQuantityKeys getQuantityKeys;
    @Inject
    protected GetQuantityReference getQuantityReference;

    public PriceQuantity evaluate(TradeLot tradeLot, CommodityPayout commodityPayout) {
        PriceQuantity priceQuantity;
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(tradeLot, commodityPayout);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot var1, CommodityPayout var2);

    protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot var1, CommodityPayout var2);

    protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot var1, CommodityPayout var2);

    public static class CommodityObservablePriceQuantityDefault
    extends CommodityObservablePriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, CommodityPayout commodityPayout) {
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, tradeLot, commodityPayout);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, TradeLot tradeLot, CommodityPayout commodityPayout) {
            priceQuantity = ExpressionOperators.exists(this.priceQuantityWithMatchingObservable(tradeLot, commodityPayout)).getOrDefault(Boolean.valueOf(false)) != false ? (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)this.priceQuantityWithMatchingObservable(tradeLot, commodityPayout).get()) : (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)this.priceQuantityWithMatchingKey(tradeLot, commodityPayout).get());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, CommodityPayout commodityPayout) {
            MapperC thenArg0 = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).map("getCommodity", observable -> observable.getCommodity()).map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity == null ? null : fieldWithMetaCommodity.getValue()), (Mapper)MapperS.of((Object)commodityPayout).map("getUnderlier", _commodityPayout -> _commodityPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((PriceQuantity)thenArg1.get()));
        }

        @Override
        protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, CommodityPayout commodityPayout) {
            MapperC thenArg = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperators.contains((Mapper)MapperC.of(this.getQuantityKeys.evaluate((PriceQuantity)item.get())), (Mapper)MapperS.of((Object)this.getQuantityReference.evaluate((ResolvablePriceQuantity)MapperS.of((Object)commodityPayout).map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).get()))).get());
            return MapperS.of((Object)((PriceQuantity)thenArg.get()));
        }
    }
}

