/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg1ZeroCouponSwapKnownAmountDefault.class)
public abstract class InterestRateLeg1ZeroCouponSwapKnownAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg1;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = this.doEvaluate(product);
        if (interestRateLeg1Builder == null) {
            interestRateLeg1 = null;
        } else {
            interestRateLeg1 = interestRateLeg1Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg1);
        }
        return interestRateLeg1;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    public static class InterestRateLeg1ZeroCouponSwapKnownAmountDefault
    extends InterestRateLeg1ZeroCouponSwapKnownAmount {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg1, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
            MapperC thenArg = MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).and(ExpressionOperators.notExists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()))).get());
            interestRateLeg1 = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)thenArg.get())).get());
            return Optional.ofNullable(interestRateLeg1).map(o -> o.prune()).orElse(null);
        }
    }
}

