/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.PartyIdentifierNaturalPersonRoles;
import drr.regulation.common.functions.PartyLei;
import javax.inject.Inject;

@ImplementedBy(value=PartyLeiAndPersonByRolesDefault.class)
public abstract class PartyLeiAndPersonByRoles
implements RosettaFunction {
    @Inject
    protected PartyIdentifierNaturalPersonRoles partyIdentifierNaturalPersonRoles;
    @Inject
    protected PartyLei partyLei0;

    public String evaluate(Party party, Party reportingParty) {
        String partyPersonLei = this.doEvaluate(party, reportingParty);
        return partyPersonLei;
    }

    protected abstract String doEvaluate(Party var1, Party var2);

    protected abstract MapperS<String> partyLei1(Party var1, Party var2);

    protected abstract MapperS<? extends FieldWithMetaString> partyPersonId(Party var1, Party var2);

    protected abstract MapperS<String> reportingPartyLei(Party var1, Party var2);

    public static class PartyLeiAndPersonByRolesDefault
    extends PartyLeiAndPersonByRoles {
        @Override
        protected String doEvaluate(Party party, Party reportingParty) {
            String partyPersonLei = null;
            return this.assignOutput(partyPersonLei, party, reportingParty);
        }

        protected String assignOutput(String partyPersonLei, Party party, Party reportingParty) {
            partyPersonLei = ExpressionOperators.exists(this.partyPersonId(party, reportingParty)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.exists(this.reportingPartyLei(party, reportingParty)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (String)MapperMaths.add(this.reportingPartyLei(party, reportingParty), (Mapper)this.partyPersonId(party, reportingParty).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())).get() : (String)MapperMaths.add(this.partyLei1(party, reportingParty), (Mapper)this.partyPersonId(party, reportingParty).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())).get()) : (String)this.partyLei1(party, reportingParty).get();
            return partyPersonLei;
        }

        @Override
        protected MapperS<String> partyLei1(Party party, Party reportingParty) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)party).mapC("getPartyId", _party -> _party.getPartyId()).map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)PartyIdentifierTypeEnum.LEI), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.partyLei0.evaluate(MapperS.of((Object)party).mapC("getPartyId", _party -> _party.getPartyId()).getMulti()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> partyPersonId(Party party, Party reportingParty) {
            MapperS thenArg0 = MapperS.of((Object)party).filterSingleNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.mapC("getPersonRole", _party -> _party.getPersonRole()).mapC("getRole", naturalPersonRole -> naturalPersonRole.getRole()).mapItem(r -> ExpressionOperators.contains((Mapper)MapperC.of(this.partyIdentifierNaturalPersonRoles.evaluate()), (Mapper)r.map("Type coercion", fieldWithMetaNaturalPersonRoleEnum -> fieldWithMetaNaturalPersonRoleEnum == null ? null : fieldWithMetaNaturalPersonRoleEnum.getValue())).asMapper()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.Any).get());
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> item.mapC("getPerson", _party -> _party.getPerson()).mapC("getPersonId", naturalPerson -> naturalPerson.getPersonId()).map("Type coercion", fieldWithMetaPersonIdentifier -> fieldWithMetaPersonIdentifier.getValue()).map("getIdentifier", personIdentifier -> personIdentifier.getIdentifier()));
            return MapperS.of((Object)((FieldWithMetaString)thenArg1.get()));
        }

        @Override
        protected MapperS<String> reportingPartyLei(Party party, Party reportingParty) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)reportingParty).mapC("getPartyId", _party -> _party.getPartyId()).map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)PartyIdentifierTypeEnum.LEI), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.partyLei0.evaluate(MapperS.of((Object)reportingParty).mapC("getPartyId", _party -> _party.getPartyId()).getMulti()));
            }
            return MapperS.ofNull();
        }
    }
}

