/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.functions.IsProductWithUnderlier;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ProductOrUnderlierProductDefault.class)
public abstract class ProductOrUnderlierProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsProductWithUnderlier isProductWithUnderlier;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Product evaluate(Product product) {
        Product productOrUnderlierProduct;
        Product.ProductBuilder productOrUnderlierProductBuilder = this.doEvaluate(product);
        if (productOrUnderlierProductBuilder == null) {
            productOrUnderlierProduct = null;
        } else {
            productOrUnderlierProduct = productOrUnderlierProductBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)productOrUnderlierProduct);
        }
        return productOrUnderlierProduct;
    }

    protected abstract Product.ProductBuilder doEvaluate(Product var1);

    public static class ProductOrUnderlierProductDefault
    extends ProductOrUnderlierProduct {
        @Override
        protected Product.ProductBuilder doEvaluate(Product product) {
            Product.ProductBuilder productOrUnderlierProduct = Product.builder();
            return this.assignOutput(productOrUnderlierProduct, product);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder productOrUnderlierProduct, Product product) {
            Boolean _boolean = this.isProductWithUnderlier.evaluate(product);
            productOrUnderlierProduct = _boolean != null && _boolean != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)this.underlierForProduct.evaluate(product)) : (Product.ProductBuilder)this.toBuilder((RosettaModelObject)product);
            return Optional.ofNullable(productOrUnderlierProduct).map(o -> o.prune()).orElse(null);
        }
    }
}

