/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.trade.meta.CommonLegMeta;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.standards.iosco.cde.base.payment.PeriodicPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommonLeg", builder=CommonLegBuilderImpl.class, version="6.17.7")
@RuneDataType(value="CommonLeg", model="drr", builder=CommonLegBuilderImpl.class, version="6.17.7")
public interface CommonLeg
extends Leg {
    public static final CommonLegMeta metaData = new CommonLegMeta();

    @Override
    public CommonPeriodicPayment getPeriodicPayment();

    public BigDecimal getNotionalQuantity();

    public ZonedDateTime getFixingDate();

    public FrequencyPeriodEnum getQuantityFrequency();

    public Integer getQuantityFrequencyMultiplier();

    public String getPayerIdentifier();

    public String getReceiverIdentifier();

    public ISOCountryCodeEnum getSettlementLocation();

    public Date getNextFloatingReferenceResetDate();

    @Override
    public CommonLeg build();

    @Override
    public CommonLegBuilder toBuilder();

    public static CommonLegBuilder builder() {
        return new CommonLegBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonLeg> getType() {
        return CommonLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.class, this.getSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonLegBuilderImpl
    implements CommonLegBuilder {
        protected CommonPeriodicPayment.CommonPeriodicPaymentBuilder periodicPayment;
        protected BigDecimal notionalAmount;
        protected List<NotionalPeriod.NotionalPeriodBuilder> notionalAmountSchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
        protected List<NotionalPeriod.NotionalPeriodBuilder> notionalQuantitySchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
        protected ISOCurrencyCodeEnum notionalCurrency;
        protected BigDecimal totalNotionalQuantity;
        protected BigDecimal fixedRate;
        protected ISOCurrencyCodeEnum settlementCurrency;
        protected PriceFormat.PriceFormatBuilder spread;
        protected PriceNotationEnum spreadNotation;
        protected ISOCurrencyCodeEnum spreadCurrency;
        protected String quantityUnitOfMeasure;
        protected Direction2Enum direction2;
        protected BigDecimal notionalQuantity;
        protected ZonedDateTime fixingDate;
        protected FrequencyPeriodEnum quantityFrequency;
        protected Integer quantityFrequencyMultiplier;
        protected String payerIdentifier;
        protected String receiverIdentifier;
        protected ISOCountryCodeEnum settlementLocation;
        protected Date nextFloatingReferenceResetDate;

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public CommonPeriodicPayment.CommonPeriodicPaymentBuilder getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        public CommonPeriodicPayment.CommonPeriodicPaymentBuilder getOrCreatePeriodicPayment() {
            CommonPeriodicPayment.CommonPeriodicPaymentBuilder result = this.periodicPayment != null ? this.periodicPayment : (this.periodicPayment = CommonPeriodicPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalAmountSchedule() {
            return this.notionalAmountSchedule;
        }

        @Override
        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalAmountSchedule(int index) {
            if (this.notionalAmountSchedule == null) {
                this.notionalAmountSchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            }
            return (NotionalPeriod.NotionalPeriodBuilder)this.getIndex(this.notionalAmountSchedule, index, () -> {
                NotionalPeriod.NotionalPeriodBuilder newNotionalAmountSchedule = NotionalPeriod.builder();
                return newNotionalAmountSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public List<? extends NotionalPeriod.NotionalPeriodBuilder> getNotionalQuantitySchedule() {
            return this.notionalQuantitySchedule;
        }

        @Override
        public NotionalPeriod.NotionalPeriodBuilder getOrCreateNotionalQuantitySchedule(int index) {
            if (this.notionalQuantitySchedule == null) {
                this.notionalQuantitySchedule = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            }
            return (NotionalPeriod.NotionalPeriodBuilder)this.getIndex(this.notionalQuantitySchedule, index, () -> {
                NotionalPeriod.NotionalPeriodBuilder newNotionalQuantitySchedule = NotionalPeriod.builder();
                return newNotionalQuantitySchedule;
            });
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public ISOCurrencyCodeEnum getNotionalCurrency() {
            return this.notionalCurrency;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public BigDecimal getTotalNotionalQuantity() {
            return this.totalNotionalQuantity;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public ISOCurrencyCodeEnum getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public PriceFormat.PriceFormatBuilder getSpread() {
            return this.spread;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreateSpread() {
            PriceFormat.PriceFormatBuilder result = this.spread != null ? this.spread : (this.spread = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public PriceNotationEnum getSpreadNotation() {
            return this.spreadNotation;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public ISOCurrencyCodeEnum getSpreadCurrency() {
            return this.spreadCurrency;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public String getQuantityUnitOfMeasure() {
            return this.quantityUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public Direction2Enum getDirection2() {
            return this.direction2;
        }

        @Override
        @RosettaAttribute(value="notionalQuantity")
        @RuneAttribute(value="notionalQuantity")
        public BigDecimal getNotionalQuantity() {
            return this.notionalQuantity;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public FrequencyPeriodEnum getQuantityFrequency() {
            return this.quantityFrequency;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplier")
        @RuneAttribute(value="quantityFrequencyMultiplier")
        public Integer getQuantityFrequencyMultiplier() {
            return this.quantityFrequencyMultiplier;
        }

        @Override
        @RosettaAttribute(value="payerIdentifier")
        @RuneAttribute(value="payerIdentifier")
        public String getPayerIdentifier() {
            return this.payerIdentifier;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifier")
        @RuneAttribute(value="receiverIdentifier")
        public String getReceiverIdentifier() {
            return this.receiverIdentifier;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public Date getNextFloatingReferenceResetDate() {
            return this.nextFloatingReferenceResetDate;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public CommonLegBuilder setPeriodicPayment(CommonPeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CommonLegBuilder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            CommonPeriodicPayment ifThenElseResult = _periodicPayment == null ? null : (_periodicPayment instanceof CommonPeriodicPayment ? (CommonPeriodicPayment)CommonPeriodicPayment.class.cast(_periodicPayment) : null);
            return this.setPeriodicPayment(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CommonLegBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public CommonLegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule) {
            if (_notionalAmountSchedule != null) {
                this.notionalAmountSchedule.add(_notionalAmountSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CommonLegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule, int idx) {
            this.getIndex(this.notionalAmountSchedule, idx, () -> _notionalAmountSchedule.toBuilder());
            return this;
        }

        @Override
        public CommonLegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            if (notionalAmountSchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalAmountSchedules) {
                    this.notionalAmountSchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountSchedule")
        public CommonLegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            this.notionalAmountSchedule = notionalAmountSchedules == null ? new ArrayList<NotionalPeriod.NotionalPeriodBuilder>() : (List)notionalAmountSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public CommonLegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule) {
            if (_notionalQuantitySchedule != null) {
                this.notionalQuantitySchedule.add(_notionalQuantitySchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CommonLegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule, int idx) {
            this.getIndex(this.notionalQuantitySchedule, idx, () -> _notionalQuantitySchedule.toBuilder());
            return this;
        }

        @Override
        public CommonLegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            if (notionalQuantitySchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalQuantitySchedules) {
                    this.notionalQuantitySchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantitySchedule")
        public CommonLegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            this.notionalQuantitySchedule = notionalQuantitySchedules == null ? new ArrayList<NotionalPeriod.NotionalPeriodBuilder>() : (List)notionalQuantitySchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public CommonLegBuilder setNotionalCurrency(ISOCurrencyCodeEnum _notionalCurrency) {
            this.notionalCurrency = _notionalCurrency == null ? null : _notionalCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public CommonLegBuilder setTotalNotionalQuantity(BigDecimal _totalNotionalQuantity) {
            this.totalNotionalQuantity = _totalNotionalQuantity == null ? null : _totalNotionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CommonLegBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CommonLegBuilder setSettlementCurrency(ISOCurrencyCodeEnum _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CommonLegBuilder setSpread(PriceFormat _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public CommonLegBuilder setSpreadNotation(PriceNotationEnum _spreadNotation) {
            this.spreadNotation = _spreadNotation == null ? null : _spreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public CommonLegBuilder setSpreadCurrency(ISOCurrencyCodeEnum _spreadCurrency) {
            this.spreadCurrency = _spreadCurrency == null ? null : _spreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public CommonLegBuilder setQuantityUnitOfMeasure(String _quantityUnitOfMeasure) {
            this.quantityUnitOfMeasure = _quantityUnitOfMeasure == null ? null : _quantityUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public CommonLegBuilder setDirection2(Direction2Enum _direction2) {
            this.direction2 = _direction2 == null ? null : _direction2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantity")
        @RuneAttribute(value="notionalQuantity")
        public CommonLegBuilder setNotionalQuantity(BigDecimal _notionalQuantity) {
            this.notionalQuantity = _notionalQuantity == null ? null : _notionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public CommonLegBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public CommonLegBuilder setQuantityFrequency(FrequencyPeriodEnum _quantityFrequency) {
            this.quantityFrequency = _quantityFrequency == null ? null : _quantityFrequency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplier")
        @RuneAttribute(value="quantityFrequencyMultiplier")
        public CommonLegBuilder setQuantityFrequencyMultiplier(Integer _quantityFrequencyMultiplier) {
            this.quantityFrequencyMultiplier = _quantityFrequencyMultiplier == null ? null : _quantityFrequencyMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerIdentifier")
        @RuneAttribute(value="payerIdentifier")
        public CommonLegBuilder setPayerIdentifier(String _payerIdentifier) {
            this.payerIdentifier = _payerIdentifier == null ? null : _payerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifier")
        @RuneAttribute(value="receiverIdentifier")
        public CommonLegBuilder setReceiverIdentifier(String _receiverIdentifier) {
            this.receiverIdentifier = _receiverIdentifier == null ? null : _receiverIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CommonLegBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public CommonLegBuilder setNextFloatingReferenceResetDate(Date _nextFloatingReferenceResetDate) {
            this.nextFloatingReferenceResetDate = _nextFloatingReferenceResetDate == null ? null : _nextFloatingReferenceResetDate;
            return this;
        }

        @Override
        public CommonLeg build() {
            return new CommonLegImpl(this);
        }

        @Override
        public CommonLegBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonLegBuilder prune() {
            if (this.periodicPayment != null && !this.periodicPayment.prune().hasData()) {
                this.periodicPayment = null;
            }
            this.notionalAmountSchedule = this.notionalAmountSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.notionalQuantitySchedule = this.notionalQuantitySchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.spread != null && !this.spread.prune().hasData()) {
                this.spread = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriodicPayment() != null && this.getPeriodicPayment().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null) {
                return true;
            }
            if (this.getNotionalAmountSchedule() != null && this.getNotionalAmountSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalQuantitySchedule() != null && this.getNotionalQuantitySchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getNotionalCurrency() != null) {
                return true;
            }
            if (this.getTotalNotionalQuantity() != null) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getSettlementCurrency() != null) {
                return true;
            }
            if (this.getSpread() != null && this.getSpread().hasData()) {
                return true;
            }
            if (this.getSpreadNotation() != null) {
                return true;
            }
            if (this.getSpreadCurrency() != null) {
                return true;
            }
            if (this.getQuantityUnitOfMeasure() != null) {
                return true;
            }
            if (this.getDirection2() != null) {
                return true;
            }
            if (this.getNotionalQuantity() != null) {
                return true;
            }
            if (this.getFixingDate() != null) {
                return true;
            }
            if (this.getQuantityFrequency() != null) {
                return true;
            }
            if (this.getQuantityFrequencyMultiplier() != null) {
                return true;
            }
            if (this.getPayerIdentifier() != null) {
                return true;
            }
            if (this.getReceiverIdentifier() != null) {
                return true;
            }
            if (this.getSettlementLocation() != null) {
                return true;
            }
            return this.getNextFloatingReferenceResetDate() != null;
        }

        public CommonLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommonLegBuilder o = (CommonLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodicPayment(), (RosettaModelObjectBuilder)o.getPeriodicPayment(), this::setPeriodicPayment);
            merger.mergeRosetta(this.getNotionalAmountSchedule(), o.getNotionalAmountSchedule(), this::getOrCreateNotionalAmountSchedule);
            merger.mergeRosetta(this.getNotionalQuantitySchedule(), o.getNotionalQuantitySchedule(), this::getOrCreateNotionalQuantitySchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpread(), (RosettaModelObjectBuilder)o.getSpread(), this::setSpread);
            merger.mergeBasic((Object)this.getNotionalAmount(), (Object)o.getNotionalAmount(), this::setNotionalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalCurrency(), (Object)o.getNotionalCurrency(), this::setNotionalCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalNotionalQuantity(), (Object)o.getTotalNotionalQuantity(), this::setTotalNotionalQuantity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementCurrency(), (Object)o.getSettlementCurrency(), this::setSettlementCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadNotation(), (Object)o.getSpreadNotation(), this::setSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadCurrency(), (Object)o.getSpreadCurrency(), this::setSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnitOfMeasure(), (Object)o.getQuantityUnitOfMeasure(), this::setQuantityUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection2(), (Object)o.getDirection2(), this::setDirection2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalQuantity(), (Object)o.getNotionalQuantity(), this::setNotionalQuantity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixingDate(), (Object)o.getFixingDate(), this::setFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequency(), (Object)o.getQuantityFrequency(), this::setQuantityFrequency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityFrequencyMultiplier(), (Object)o.getQuantityFrequencyMultiplier(), this::setQuantityFrequencyMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayerIdentifier(), (Object)o.getPayerIdentifier(), this::setPayerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReceiverIdentifier(), (Object)o.getReceiverIdentifier(), this::setReceiverIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementLocation(), (Object)o.getSettlementLocation(), this::setSettlementLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDate(), (Object)o.getNextFloatingReferenceResetDate(), this::setNextFloatingReferenceResetDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommonLeg _that = this.getType().cast(o);
            if (!Objects.equals(this.periodicPayment, _that.getPeriodicPayment())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalAmountSchedule, _that.getNotionalAmountSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notionalQuantitySchedule, _that.getNotionalQuantitySchedule())) {
                return false;
            }
            if (!Objects.equals(this.notionalCurrency, _that.getNotionalCurrency())) {
                return false;
            }
            if (!Objects.equals(this.totalNotionalQuantity, _that.getTotalNotionalQuantity())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.spreadNotation, (Object)_that.getSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.spreadCurrency, _that.getSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnitOfMeasure, _that.getQuantityUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction2, (Object)_that.getDirection2())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantity, _that.getNotionalQuantity())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.quantityFrequency, (Object)_that.getQuantityFrequency())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplier, _that.getQuantityFrequencyMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.payerIdentifier, _that.getPayerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.receiverIdentifier, _that.getReceiverIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            return Objects.equals(this.nextFloatingReferenceResetDate, _that.getNextFloatingReferenceResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmountSchedule != null ? this.notionalAmountSchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantitySchedule != null ? this.notionalQuantitySchedule.hashCode() : 0);
            _result = 31 * _result + (this.notionalCurrency != null ? this.notionalCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalNotionalQuantity != null ? this.totalNotionalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotation != null ? ((Object)((Object)this.spreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrency != null ? this.spreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityUnitOfMeasure != null ? this.quantityUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.direction2 != null ? ((Object)((Object)this.direction2)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantity != null ? this.notionalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequency != null ? ((Object)((Object)this.quantityFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplier != null ? this.quantityFrequencyMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.payerIdentifier != null ? this.payerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.receiverIdentifier != null ? this.receiverIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDate != null ? this.nextFloatingReferenceResetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommonLegBuilder {periodicPayment=" + String.valueOf(this.periodicPayment) + ", notionalAmount=" + String.valueOf(this.notionalAmount) + ", notionalAmountSchedule=" + String.valueOf(this.notionalAmountSchedule) + ", notionalQuantitySchedule=" + String.valueOf(this.notionalQuantitySchedule) + ", notionalCurrency=" + String.valueOf(this.notionalCurrency) + ", totalNotionalQuantity=" + String.valueOf(this.totalNotionalQuantity) + ", fixedRate=" + String.valueOf(this.fixedRate) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", spread=" + String.valueOf(this.spread) + ", spreadNotation=" + String.valueOf((Object)this.spreadNotation) + ", spreadCurrency=" + String.valueOf(this.spreadCurrency) + ", quantityUnitOfMeasure=" + this.quantityUnitOfMeasure + ", direction2=" + String.valueOf((Object)this.direction2) + ", notionalQuantity=" + String.valueOf(this.notionalQuantity) + ", fixingDate=" + String.valueOf(this.fixingDate) + ", quantityFrequency=" + String.valueOf((Object)this.quantityFrequency) + ", quantityFrequencyMultiplier=" + this.quantityFrequencyMultiplier + ", payerIdentifier=" + this.payerIdentifier + ", receiverIdentifier=" + this.receiverIdentifier + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", nextFloatingReferenceResetDate=" + String.valueOf(this.nextFloatingReferenceResetDate) + "}";
        }
    }

    public static interface CommonLegBuilder
    extends CommonLeg,
    Leg.LegBuilder {
        @Override
        public CommonPeriodicPayment.CommonPeriodicPaymentBuilder getOrCreatePeriodicPayment();

        @Override
        public CommonPeriodicPayment.CommonPeriodicPaymentBuilder getPeriodicPayment();

        @Override
        public CommonLegBuilder setPeriodicPayment(PeriodicPayment var1);

        @Override
        public CommonLegBuilder setNotionalAmount(BigDecimal var1);

        @Override
        public CommonLegBuilder addNotionalAmountSchedule(NotionalPeriod var1);

        @Override
        public CommonLegBuilder addNotionalAmountSchedule(NotionalPeriod var1, int var2);

        @Override
        public CommonLegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CommonLegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CommonLegBuilder addNotionalQuantitySchedule(NotionalPeriod var1);

        @Override
        public CommonLegBuilder addNotionalQuantitySchedule(NotionalPeriod var1, int var2);

        @Override
        public CommonLegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CommonLegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CommonLegBuilder setNotionalCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonLegBuilder setTotalNotionalQuantity(BigDecimal var1);

        @Override
        public CommonLegBuilder setFixedRate(BigDecimal var1);

        @Override
        public CommonLegBuilder setSettlementCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonLegBuilder setSpread(PriceFormat var1);

        @Override
        public CommonLegBuilder setSpreadNotation(PriceNotationEnum var1);

        @Override
        public CommonLegBuilder setSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonLegBuilder setQuantityUnitOfMeasure(String var1);

        @Override
        public CommonLegBuilder setDirection2(Direction2Enum var1);

        public CommonLegBuilder setPeriodicPayment(CommonPeriodicPayment var1);

        public CommonLegBuilder setNotionalQuantity(BigDecimal var1);

        public CommonLegBuilder setFixingDate(ZonedDateTime var1);

        public CommonLegBuilder setQuantityFrequency(FrequencyPeriodEnum var1);

        public CommonLegBuilder setQuantityFrequencyMultiplier(Integer var1);

        public CommonLegBuilder setPayerIdentifier(String var1);

        public CommonLegBuilder setReceiverIdentifier(String var1);

        public CommonLegBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        public CommonLegBuilder setNextFloatingReferenceResetDate(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.CommonPeriodicPaymentBuilder.class, this.getPeriodicPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommonLegBuilder prune();
    }

    public static class CommonLegImpl
    extends Leg.LegImpl
    implements CommonLeg {
        private final CommonPeriodicPayment periodicPayment;
        private final BigDecimal notionalQuantity;
        private final ZonedDateTime fixingDate;
        private final FrequencyPeriodEnum quantityFrequency;
        private final Integer quantityFrequencyMultiplier;
        private final String payerIdentifier;
        private final String receiverIdentifier;
        private final ISOCountryCodeEnum settlementLocation;
        private final Date nextFloatingReferenceResetDate;

        protected CommonLegImpl(CommonLegBuilder builder) {
            super(builder);
            this.periodicPayment = Optional.ofNullable(builder.getPeriodicPayment()).map(f -> f.build()).orElse(null);
            this.notionalQuantity = builder.getNotionalQuantity();
            this.fixingDate = builder.getFixingDate();
            this.quantityFrequency = builder.getQuantityFrequency();
            this.quantityFrequencyMultiplier = builder.getQuantityFrequencyMultiplier();
            this.payerIdentifier = builder.getPayerIdentifier();
            this.receiverIdentifier = builder.getReceiverIdentifier();
            this.settlementLocation = builder.getSettlementLocation();
            this.nextFloatingReferenceResetDate = builder.getNextFloatingReferenceResetDate();
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public CommonPeriodicPayment getPeriodicPayment() {
            return this.periodicPayment;
        }

        @Override
        @RosettaAttribute(value="notionalQuantity")
        @RuneAttribute(value="notionalQuantity")
        public BigDecimal getNotionalQuantity() {
            return this.notionalQuantity;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public FrequencyPeriodEnum getQuantityFrequency() {
            return this.quantityFrequency;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplier")
        @RuneAttribute(value="quantityFrequencyMultiplier")
        public Integer getQuantityFrequencyMultiplier() {
            return this.quantityFrequencyMultiplier;
        }

        @Override
        @RosettaAttribute(value="payerIdentifier")
        @RuneAttribute(value="payerIdentifier")
        public String getPayerIdentifier() {
            return this.payerIdentifier;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifier")
        @RuneAttribute(value="receiverIdentifier")
        public String getReceiverIdentifier() {
            return this.receiverIdentifier;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public Date getNextFloatingReferenceResetDate() {
            return this.nextFloatingReferenceResetDate;
        }

        @Override
        public CommonLeg build() {
            return this;
        }

        @Override
        public CommonLegBuilder toBuilder() {
            CommonLegBuilder builder = CommonLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodicPayment()).ifPresent(builder::setPeriodicPayment);
            Optional.ofNullable(this.getNotionalQuantity()).ifPresent(builder::setNotionalQuantity);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getQuantityFrequency()).ifPresent(builder::setQuantityFrequency);
            Optional.ofNullable(this.getQuantityFrequencyMultiplier()).ifPresent(builder::setQuantityFrequencyMultiplier);
            Optional.ofNullable(this.getPayerIdentifier()).ifPresent(builder::setPayerIdentifier);
            Optional.ofNullable(this.getReceiverIdentifier()).ifPresent(builder::setReceiverIdentifier);
            Optional.ofNullable(this.getSettlementLocation()).ifPresent(builder::setSettlementLocation);
            Optional.ofNullable(this.getNextFloatingReferenceResetDate()).ifPresent(builder::setNextFloatingReferenceResetDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonLeg _that = (CommonLeg)this.getType().cast(o);
            if (!Objects.equals(this.periodicPayment, _that.getPeriodicPayment())) {
                return false;
            }
            if (!Objects.equals(this.notionalQuantity, _that.getNotionalQuantity())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.quantityFrequency, (Object)_that.getQuantityFrequency())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequencyMultiplier, _that.getQuantityFrequencyMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.payerIdentifier, _that.getPayerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.receiverIdentifier, _that.getReceiverIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            return Objects.equals(this.nextFloatingReferenceResetDate, _that.getNextFloatingReferenceResetDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodicPayment != null ? this.periodicPayment.hashCode() : 0);
            _result = 31 * _result + (this.notionalQuantity != null ? this.notionalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequency != null ? ((Object)((Object)this.quantityFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequencyMultiplier != null ? this.quantityFrequencyMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.payerIdentifier != null ? this.payerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.receiverIdentifier != null ? this.receiverIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDate != null ? this.nextFloatingReferenceResetDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonLeg {periodicPayment=" + String.valueOf(this.periodicPayment) + ", notionalQuantity=" + String.valueOf(this.notionalQuantity) + ", fixingDate=" + String.valueOf(this.fixingDate) + ", quantityFrequency=" + String.valueOf((Object)this.quantityFrequency) + ", quantityFrequencyMultiplier=" + this.quantityFrequencyMultiplier + ", payerIdentifier=" + this.payerIdentifier + ", receiverIdentifier=" + this.receiverIdentifier + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", nextFloatingReferenceResetDate=" + String.valueOf(this.nextFloatingReferenceResetDate) + "} " + super.toString();
        }
    }
}

