/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.event.common.Trade;
import cdm.product.asset.ReferencePoolItem;
import cdm.product.template.BasketConstituent;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.trade.basket.functions.GetQuantityForConstituent;
import drr.regulation.common.trade.basket.functions.GetQuantityForReferencePoolItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetBasketConstituentsDefault.class)
public abstract class GetBasketConstituents
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetQuantityForConstituent getQuantityForConstituent;
    @Inject
    protected GetQuantityForReferencePoolItem getQuantityForReferencePoolItem;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<? extends BasketConstituent> evaluate(Trade trade) {
        List result;
        List<BasketConstituent.BasketConstituentBuilder> resultBuilder = this.doEvaluate(trade);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.stream().map(BasketConstituent::build).collect(Collectors.toList());
            this.objectValidator.validate(BasketConstituent.class, result);
        }
        return result;
    }

    protected abstract List<BasketConstituent.BasketConstituentBuilder> doEvaluate(Trade var1);

    protected abstract MapperS<? extends Product> product(Trade var1);

    protected abstract MapperC<? extends TradeLot> tradeLots(Trade var1);

    protected abstract MapperC<? extends Product> basketConstituents(Trade var1);

    protected abstract MapperC<? extends ReferencePoolItem> referencePoolItems(Trade var1);

    public static class GetBasketConstituentsDefault
    extends GetBasketConstituents {
        @Override
        protected List<BasketConstituent.BasketConstituentBuilder> doEvaluate(Trade trade) {
            ArrayList<BasketConstituent.BasketConstituentBuilder> result = new ArrayList<BasketConstituent.BasketConstituentBuilder>();
            return this.assignOutput(result, trade);
        }

        protected List<BasketConstituent.BasketConstituentBuilder> assignOutput(List<BasketConstituent.BasketConstituentBuilder> result, Trade trade) {
            MapperC<? extends Product> thenArg0 = this.basketConstituents(trade);
            result.addAll(this.toBuilder(thenArg0.mapItem(item -> {
                NonNegativeQuantitySchedule nonNegativeQuantitySchedule = this.getQuantityForConstituent.evaluate((Product)item.get(), this.tradeLots(trade).getMulti());
                return MapperS.of((Object)BasketConstituent.builder().setQuantityValue(nonNegativeQuantitySchedule == null ? Collections.emptyList() : Collections.singletonList(nonNegativeQuantitySchedule)).setSecurity((Security)item.map("getSecurity", _product -> _product.getSecurity()).get()).setLoan((Loan)item.map("getLoan", _product -> _product.getLoan()).get()).setCommodity((ReferenceWithMetaCommodity)item.map("getCommodity", _product -> _product.getCommodity()).get()).setIndex((Index)item.map("getIndex", _product -> _product.getIndex()).get()).build());
            }).getMulti()));
            MapperC<? extends ReferencePoolItem> thenArg1 = this.referencePoolItems(trade);
            result.addAll(this.toBuilder(thenArg1.mapItem(item -> {
                NonNegativeQuantitySchedule nonNegativeQuantitySchedule = this.getQuantityForReferencePoolItem.evaluate((ReferencePoolItem)item.get());
                return MapperS.of((Object)BasketConstituent.builder().setQuantityValue(nonNegativeQuantitySchedule == null ? Collections.emptyList() : Collections.singletonList(nonNegativeQuantitySchedule)).setSecurity((Security)item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).get()).setLoan((Loan)item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getLoan", referenceObligation -> referenceObligation.getLoan()).get()).build());
            }).getMulti()));
            return Optional.ofNullable(result).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Product> product(Trade trade) {
            return MapperS.of((Object)this.productForTrade.evaluate(trade));
        }

        @Override
        protected MapperC<? extends TradeLot> tradeLots(Trade trade) {
            return MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot());
        }

        @Override
        protected MapperC<? extends Product> basketConstituents(Trade trade) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(trade).get())).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(trade).get())).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent())).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isSingleCommodityPayoutProduct.evaluate((Product)this.product(trade).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent());
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<? extends ReferencePoolItem> referencePoolItems(Trade trade) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem());
            }
            return MapperC.ofNull();
        }
    }
}

