/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.contract.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.OptionTypeCode;
import javax.inject.Inject;

@ImplementedBy(value=OptionTypeRuleDefault.class)
public abstract class OptionTypeRule
implements ReportFunction<TransactionReportInstruction, OptionTypeCode> {
    @Inject
    protected IsCallOption isCallOption;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsFloor isFloor;
    @Inject
    protected IsOption isOption;
    @Inject
    protected IsPutOption isPutOption;
    @Inject
    protected ProductForEvent productForEvent;

    public OptionTypeCode evaluate(TransactionReportInstruction input) {
        OptionTypeCode output = this.doEvaluate(input);
        return output;
    }

    protected abstract OptionTypeCode doEvaluate(TransactionReportInstruction var1);

    public static class OptionTypeRuleDefault
    extends OptionTypeRule {
        @Override
        protected OptionTypeCode doEvaluate(TransactionReportInstruction input) {
            OptionTypeCode output = null;
            return this.assignOutput(output, input);
        }

        protected OptionTypeCode assignOutput(OptionTypeCode output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            output = (OptionTypeCode)((Object)thenArg.mapSingleToItem(item -> {
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isPutOption.evaluate((Product)item.get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isFloor.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)OptionTypeCode.PUTO));
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCallOption.evaluate((Product)item.get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isCap.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)OptionTypeCode.CALL));
                }
                Boolean _boolean = this.isOption.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)((Object)OptionTypeCode.OTHR));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

