/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.index.functions;

import cdm.base.staticdata.asset.common.DebtSeniorityEnum;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.CreditSeniorityEnum;
import cdm.product.asset.ReferenceInformation;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditDefaultSwapBasket;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iso.SeniorityEnum;
import javax.inject.Inject;

@ImplementedBy(value=GetSeniorityDefault.class)
public abstract class GetSeniority
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsCreditDefaultSwapBasket isCreditDefaultSwapBasket;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public SeniorityEnum evaluate(ReportableEvent reportableEvent) {
        SeniorityEnum result = this.doEvaluate(reportableEvent);
        return result;
    }

    protected abstract SeniorityEnum doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends Product> product(ReportableEvent var1);

    protected abstract MapperS<? extends CreditIndexReferenceInformation> indexReferenceInformation(ReportableEvent var1);

    protected abstract MapperS<? extends ReferenceInformation> referenceInformation(ReportableEvent var1);

    protected abstract MapperS<? extends BasketReferenceInformation> basketReferenceInformation(ReportableEvent var1);

    protected abstract MapperS<CreditSeniorityEnum> creditSeniority(ReportableEvent var1);

    protected abstract MapperC<DebtSeniorityEnum> debtSeniority(ReportableEvent var1);

    protected abstract MapperC<DebtSeniorityEnum> basketSeniority(ReportableEvent var1);

    public static class GetSeniorityDefault
    extends GetSeniority {
        @Override
        protected SeniorityEnum doEvaluate(ReportableEvent reportableEvent) {
            SeniorityEnum result = null;
            return this.assignOutput(result, reportableEvent);
        }

        protected SeniorityEnum assignOutput(SeniorityEnum result, ReportableEvent reportableEvent) {
            result = ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SENIOR_UN_SEC), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SENIOR_SEC), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SENIOR_LOSS_ABSORBING_CAPACITY), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.debtSeniority(reportableEvent), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SENIOR), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.areEqual(this.basketSeniority(reportableEvent), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SENIOR), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? SeniorityEnum.SNDB : (ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SUB_TIER_3), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SUB_UPPER_TIER_2), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SUB_LOWER_TIER_2), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.SUB_TIER_1), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.debtSeniority(reportableEvent), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SUBORDINATED), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.areEqual(this.basketSeniority(reportableEvent), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SUBORDINATED), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? SeniorityEnum.SBOD : (ExpressionOperators.areEqual(this.creditSeniority(reportableEvent), (Mapper)MapperS.of((Object)CreditSeniorityEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.debtSeniority(reportableEvent), (Mapper)MapperS.of((Object)DebtSeniorityEnum.SECURED), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.exists(this.basketSeniority(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? SeniorityEnum.OTHR : null));
            return result;
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends CreditIndexReferenceInformation> indexReferenceInformation(ReportableEvent reportableEvent) {
            Boolean boolean0 = this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
            }
            Boolean boolean1 = this.isCreditDefaultSwap.evaluate((Product)this.product(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends ReferenceInformation> referenceInformation(ReportableEvent reportableEvent) {
            Boolean boolean0 = this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
            }
            Boolean boolean1 = this.isCreditDefaultSwap.evaluate((Product)this.product(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends BasketReferenceInformation> basketReferenceInformation(ReportableEvent reportableEvent) {
            Boolean boolean0 = this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation());
            }
            Boolean boolean1 = this.isCreditDefaultSwapBasket.evaluate((Product)this.product(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<CreditSeniorityEnum> creditSeniority(ReportableEvent reportableEvent) {
            return this.indexReferenceInformation(reportableEvent).map("getSeniority", creditIndexReferenceInformation -> creditIndexReferenceInformation.getSeniority());
        }

        @Override
        protected MapperC<DebtSeniorityEnum> debtSeniority(ReportableEvent reportableEvent) {
            if (ExpressionOperators.exists(this.referenceInformation(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.referenceInformation(reportableEvent).mapC("getReferenceObligation", _referenceInformation -> _referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getDebtType", security -> security.getDebtType()).mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
            }
            Boolean _boolean = this.isTotalReturnSwapDebtUnderlier.evaluate((Product)this.product(reportableEvent).get());
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).map("getDebtType", security -> security.getDebtType()).mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<DebtSeniorityEnum> basketSeniority(ReportableEvent reportableEvent) {
            if (ExpressionOperators.exists(this.basketReferenceInformation(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.basketReferenceInformation(reportableEvent).map("getReferencePool", _basketReferenceInformation -> _basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getDebtType", security -> security.getDebtType()).mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
            }
            return MapperC.ofNull();
        }
    }
}

