/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.quantity.functions;

import cdm.base.datetime.Frequency;
import cdm.event.common.Trade;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.CommodityForwardObservablePriceQuantity;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FrequencyPeriod;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.trade.quantity.QuantityFrequency;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=QuantityFrequencyLeg2Default.class)
public abstract class QuantityFrequencyLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityForwardObservablePriceQuantity commodityForwardObservablePriceQuantity;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
    @Inject
    protected FrequencyPeriod frequencyPeriod;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
    @Inject
    protected TradeForEvent tradeForEvent;

    public QuantityFrequency evaluate(ReportableEvent reportableEvent) {
        QuantityFrequency quantityFrequency;
        QuantityFrequency.QuantityFrequencyBuilder quantityFrequencyBuilder = this.doEvaluate(reportableEvent);
        if (quantityFrequencyBuilder == null) {
            quantityFrequency = null;
        } else {
            quantityFrequency = quantityFrequencyBuilder.build();
            this.objectValidator.validate(QuantityFrequency.class, (RosettaModelObject)quantityFrequency);
        }
        return quantityFrequency;
    }

    protected abstract QuantityFrequency.QuantityFrequencyBuilder doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends PriceQuantity> quantity(ReportableEvent var1);

    protected abstract MapperS<? extends Frequency> frequency(ReportableEvent var1);

    public static class QuantityFrequencyLeg2Default
    extends QuantityFrequencyLeg2 {
        @Override
        protected QuantityFrequency.QuantityFrequencyBuilder doEvaluate(ReportableEvent reportableEvent) {
            QuantityFrequency.QuantityFrequencyBuilder quantityFrequency = QuantityFrequency.builder();
            return this.assignOutput(quantityFrequency, reportableEvent);
        }

        protected QuantityFrequency.QuantityFrequencyBuilder assignOutput(QuantityFrequency.QuantityFrequencyBuilder quantityFrequency, ReportableEvent reportableEvent) {
            quantityFrequency = (QuantityFrequency.QuantityFrequencyBuilder)this.toBuilder(QuantityFrequency.builder().setPeriod(this.frequencyPeriod.evaluate((PriceQuantity)this.quantity(reportableEvent).get(), (Frequency)this.frequency(reportableEvent).get())).setPeriodMultiplier((Integer)this.frequency(reportableEvent).map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).get()).build());
            return Optional.ofNullable(quantityFrequency).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PriceQuantity> quantity(ReportableEvent reportableEvent) {
            MapperS thenArg = MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent));
            return thenArg.mapSingleToItem(item -> {
                Boolean boolean0 = this.isCommoditySwap.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.commodityObservablePriceQuantity.evaluate((TradeLot)item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), this.commodityLeg2.evaluate(this.productForTrade.evaluate((Trade)item.get()))));
                }
                Boolean boolean1 = this.isCommodityFixedPriceForward.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean1 != null && boolean1.booleanValue()) {
                    MapperC _thenArg = item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(pq -> ExpressionOperators.notExists((Mapper)pq.mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get());
                    return MapperS.of((Object)((PriceQuantity)_thenArg.get()));
                }
                Boolean boolean2 = this.isCommodityFloatingPriceForward.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean2 != null && boolean2.booleanValue()) {
                    return MapperS.of((Object)this.commodityForwardObservablePriceQuantity.evaluate((TradeLot)item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ForwardPayout)MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()));
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<? extends Frequency> frequency(ReportableEvent reportableEvent) {
            MapperS thenArg = MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent));
            return thenArg.mapSingleToItem(item -> {
                Boolean boolean0 = this.isCommoditySwap.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.quantityFrequencyOrCalculationPeriod.evaluate((CalculationPeriodDates)MapperS.of((Object)this.commodityLeg2.evaluate(this.productForTrade.evaluate((Trade)item.get()))).map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), this.commodityObservablePriceQuantity.evaluate((TradeLot)item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), this.commodityLeg2.evaluate(this.productForTrade.evaluate((Trade)item.get())))));
                }
                Boolean boolean1 = this.isCommodityFixedPriceForward.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)((Frequency)item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(pq -> ExpressionOperators.notExists((Mapper)pq.mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(q -> ExpressionOperators.exists((Mapper)q.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).get()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).get()));
                }
                Boolean boolean2 = this.isCommodityFloatingPriceForward.evaluate(this.productForTrade.evaluate((Trade)item.get()));
                if (boolean2 != null && boolean2.booleanValue()) {
                    return MapperS.of((Object)this.quantityFrequencyOrCalculationPeriod.evaluate((CalculationPeriodDates)MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), this.commodityForwardObservablePriceQuantity.evaluate((TradeLot)item.map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ForwardPayout)MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())));
                }
                return MapperS.ofNull();
            });
        }
    }
}

