/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.util.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=SubStringDefault.class)
public abstract class SubString
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;

    public String evaluate(String text, Integer startIndex, Integer length) {
        this.conditionValidator.validate(() -> ExpressionOperators.notEqual((Mapper)MapperS.of((Object)startIndex), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.Any), "Minimum start index should be 1.");
        String subString = this.doEvaluate(text, startIndex, length);
        return subString;
    }

    protected abstract String doEvaluate(String var1, Integer var2, Integer var3);

    public static class SubStringDefault
    extends SubString {
        @Override
        protected String doEvaluate(String text, Integer startIndex, Integer length) {
            String subString = null;
            return this.assignOutput(subString, text, startIndex, length);
        }

        protected String assignOutput(String subString, String text, Integer startIndex, Integer length) {
            return subString;
        }
    }
}

