/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import javax.inject.Inject;

@ImplementedBy(value=SettlementLocationRuleDefault.class)
public abstract class SettlementLocationRule
implements ReportFunction<TransactionReportInstruction, ISOCountryCodeEnum> {
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected drr.standards.iosco.cde.version3.execution.reports.SettlementLocationRule settlementLocationRule;

    public ISOCountryCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCountryCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCountryCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SettlementLocationRuleDefault
    extends SettlementLocationRule {
        @Override
        protected ISOCountryCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCountryCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCountryCodeEnum assignOutput(ISOCountryCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            output = (ISOCountryCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.settlementLocationRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

