/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportDTCC_CSA_VR_0027_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportDTCC_CSA_VR_0027_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportDTCC_CSA_VR_0027_01";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Foreign_Exchange or dtccAdditionalFields -> primaryAssetClass = ForeignExchange) and [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and (nonReportable -> postUpiData -> Header -> InstrumentType = Option or nonReportable -> instrumentType = Option) then leg1 -> notionalCurrency = callCurrency or leg1 -> notionalCurrency = putCurrency";

    public static class NoOp
    implements CSATransactionReportDTCC_CSA_VR_0027_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportDTCC_CSA_VR_0027_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportDTCC_CSA_VR_0027_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0027_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportDTCC_CSA_VR_0027_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0027_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getActionType", _cSATransactionReport -> _cSATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cSATransactionReport).map("getCallCurrency", _cSATransactionReport -> _cSATransactionReport.getCallCurrency()), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cSATransactionReport).map("getPutCurrency", _cSATransactionReport -> _cSATransactionReport.getPutCurrency()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

