/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.qualification.functions.Qualify_Compression;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsMax32UpperCaseAlphanumericText;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.version3.link.reports.PriorUTIRule;
import javax.inject.Inject;

@ImplementedBy(value=PriorUtiRuleDefault.class)
public abstract class PriorUtiRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsMax32UpperCaseAlphanumericText isMax32UpperCaseAlphanumericText;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected Qualify_Compression qualify_Compression;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PriorUtiRuleDefault
    extends PriorUtiRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            if (ExpressionOperators.exists((Mapper)thenArg0.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).map("getCounterpartyPositionBusinessEvent", workflowStep -> workflowStep.getCounterpartyPositionBusinessEvent())).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)thenArg0.get())).mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).map("Type coercion", _fieldWithMetaString -> _fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)thenArg0.get())).mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).map("Type coercion", _fieldWithMetaString -> _fieldWithMetaString.getValue()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_Compression.evaluate((BusinessEvent)thenArg0.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = thenArg0.mapSingleToItem(item -> {
                    String string = this.priorUTIRule.evaluate((TransactionReportInstruction)item.get());
                    return string == null ? MapperS.ofNull() : MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build());
                });
            } else {
                MapperC thenArg1 = thenArg0.mapSingleToList(item -> item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()));
                MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getRegimeName", transactionInformation -> transactionInformation.getRegimeName()).map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.EMIR)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)item.map("getPriorTransactionIdentifier", transactionInformation -> transactionInformation.getPriorTransactionIdentifier()).map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All)).get());
                MapperListOfLists thenArg3 = thenArg2.mapItemToList(item -> item.map("getPriorTransactionIdentifier", transactionInformation -> transactionInformation.getPriorTransactionIdentifier()).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
                MapperC thenArg4 = thenArg3.flattenList();
                MapperC thenArg5 = ExpressionOperators.distinct((Mapper)thenArg4);
                ifThenElseResult = MapperS.of((Object)((FieldWithMetaString)thenArg5.get()));
            }
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)ifThenElseResult.filterSingleNullSafe(item -> {
                FieldWithMetaString _fieldWithMetaString = (FieldWithMetaString)item.get();
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isMax32UpperCaseAlphanumericText.evaluate(_fieldWithMetaString == null ? null : _fieldWithMetaString.getValue())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get();
            }).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

