/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=ValuationCurrencyRuleDefault.class)
public abstract class ValuationCurrencyRule
implements ReportFunction<ValuationReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public ISOCurrencyCodeEnum evaluate(ValuationReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(ValuationReportInstruction var1);

    public static class ValuationCurrencyRuleDefault
    extends ValuationCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(ValuationReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, ValuationReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> item.map("getValuationDetails", valuationReportInstruction -> valuationReportInstruction.getValuationDetails()).map("getValuation", valuationDetails -> valuationDetails.getValuation()).map("getAmount", valuation -> valuation.getAmount()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

