/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg1Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIdentifierLeg1Rule;
import drr.regulation.common.trade.underlier.reports.NameOfTheFloatingRateOfLeg1Rule;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.regulation.mas.rewrite.trade.reports.SpreadNotationOfLeg1Rule;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg1Rule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule
implements ReportFunction<TransactionReportInstruction, CommonLeg> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FloatingRateIdentifierLeg1Rule floatingRateIdentifierLeg1Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected Leg1 leg1;
    @Inject
    protected LegEnrichment legEnrichment;
    @Inject
    protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
    @Inject
    protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
    @Inject
    protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
    @Inject
    protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
    @Inject
    protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
    @Inject
    protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;

    public CommonLeg evaluate(TransactionReportInstruction input) {
        CommonLeg output;
        CommonLeg.CommonLegBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction var1);

    public static class Leg1ReportRuleDefault
    extends Leg1ReportRule {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
            CommonLeg.CommonLegBuilder output = CommonLeg.builder();
            return this.assignOutput(output, input);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            if (ExpressionOperators.exists((Mapper)thenArg).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                BigInteger bigInteger = new BigInteger("9999999999999999999999999");
                ifThenElseResult = MapperS.of((Object)this.legEnrichment.evaluate(this.leg1.evaluate((TransactionReportInstruction)thenArg.get(), this.spreadNotationOfLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigInteger == null ? null : new BigDecimal(bigInteger)), this.notionalAmountScheduleLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.notionalQuantityScheduleLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.notionalQuantityLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateResetFrequencyPeriodLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, (FrequencyPeriodEnum)((Object)MapperS.of((Object)this.quantityFrequencyLeg1.evaluate((ReportableEvent)thenArg.get())).map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get()), (Integer)MapperS.of((Object)this.quantityFrequencyLeg1.evaluate((ReportableEvent)thenArg.get())).map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, this.floatingRateIdentifierLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, null, this.nameOfTheFloatingRateOfLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get())));
            } else {
                ifThenElseResult = MapperS.ofNull();
            }
            output = (CommonLeg.CommonLegBuilder)this.toBuilder((RosettaModelObject)ifThenElseResult.get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

