/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceNotationRuleDefault.class)
public abstract class StrikePriceNotationRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected DefaultPercentageToDecimal defaultPercentageToDecimal;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceNotationRuleDefault
    extends StrikePriceNotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            output = (PriceNotationEnum)((Object)MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.strikePriceNotationEnumRule.evaluate((TransactionReportInstruction)thenArg.get()), ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.strikePriceNotationEnumRule.evaluate((TransactionReportInstruction)thenArg.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate(this.productForEvent.evaluate((ReportableEvent)thenArg.get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate(this.productForEvent.evaluate((ReportableEvent)thenArg.get())))))).get()))).get());
            return output;
        }
    }
}

