/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbUseCaseEnum;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0076_03")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0076_03
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0076_03";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and assetClass = CommonAssetClass -> CURR and contractType = CommonContractType -> OPTN then (if nonReportable -> postUpiData -> Header -> InstrumentType = AnnaDsbInstrumentTypeEnum -> Option and nonReportable -> postUpiData -> Header -> AssetClass = AnnaDsbAssetClassEnum -> Foreign_Exchange and nonReportable -> postUpiData -> Header -> UseCase <> AnnaDsbUseCaseEnum -> Digital_Option then [callAmount, putAmount] any = leg1 -> notionalAmount or leg1 -> notionalAmount = 9999999999999999999999999 and (if [CommonAssetClass -> CRDT, CommonAssetClass -> EQUI, CommonAssetClass -> CURR, CommonAssetClass -> INTR] any = assetClass then leg1 -> notionalAmount exists and leg1 -> notionalAmount >= 0))";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0076_03 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0076_03 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0076_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0076_03.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0076_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0076_03.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getNonReportable", _mASTransactionReport -> _mASTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getNonReportable", _mASTransactionReport -> _mASTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getNonReportable", _mASTransactionReport -> _mASTransactionReport.getNonReportable()).map("getPostUpiData", nonReportable -> nonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getUseCase", annaDsbHeader -> annaDsbHeader.getUseCase()), (Mapper)MapperS.of((Object)((Object)AnnaDsbUseCaseEnum.DIGITAL_OPTION)), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        BigInteger bigInteger = new BigInteger("9999999999999999999999999");
                        ComparisonResult ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.CRDT)), MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.CURR)), MapperS.of((Object)((Object)CommonAssetClass.INTR))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).and(ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)) : ComparisonResult.successEmptyOperand((String)"");
                        return ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)mASTransactionReport).map("getCallAmount", _mASTransactionReport -> _mASTransactionReport.getCallAmount()), MapperS.of((Object)mASTransactionReport).map("getPutAmount", _mASTransactionReport -> _mASTransactionReport.getPutAmount())}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)(bigInteger == null ? MapperS.ofNull() : MapperS.of((Object)new BigDecimal(bigInteger))), (CardinalityOperator)CardinalityOperator.All).and(ifThenElseResult));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

