/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0084_01")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0084_01
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0084_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and assetClass = CommonAssetClass -> COMM then if [FrequencyPeriodEnum -> HOUL, FrequencyPeriodEnum -> DAIL, FrequencyPeriodEnum -> WEEK, FrequencyPeriodEnum -> MNTH, FrequencyPeriodEnum -> QURT, FrequencyPeriodEnum -> MIAN, FrequencyPeriodEnum -> YEAR, FrequencyPeriodEnum -> EXPI] any = leg1 -> quantityFrequency then leg1 -> quantityFrequencyMultiplier exists and leg1 -> quantityFrequencyMultiplier > 0 else if leg1 -> quantityFrequency = ODMD then leg1 -> quantityFrequencyMultiplier is absent";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0084_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0084_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0084_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0084_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0084_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0084_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.COMM)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)FrequencyPeriodEnum.HOUL)), MapperS.of((Object)((Object)FrequencyPeriodEnum.DAIL)), MapperS.of((Object)((Object)FrequencyPeriodEnum.WEEK)), MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), MapperS.of((Object)((Object)FrequencyPeriodEnum.QURT)), MapperS.of((Object)((Object)FrequencyPeriodEnum.MIAN)), MapperS.of((Object)((Object)FrequencyPeriodEnum.YEAR)), MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier())).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All));
                    }
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.ODMD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier()));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

