/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0122_01")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0122_01
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0122_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod exists and [FrequencyPeriodEnum -> YEAR, FrequencyPeriodEnum -> MNTH, FrequencyPeriodEnum -> WEEK, FrequencyPeriodEnum -> DAIL, FrequencyPeriodEnum -> QURT, FrequencyPeriodEnum -> EXPI] any = leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod then (leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier exists and leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier > 0 and leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier < 1000 and if leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod = FrequencyPeriodEnum -> EXPI then leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier = 1 else True) else if leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod is absent or leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriod = FrequencyPeriodEnum -> ADHO then leg2 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier is absent";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0122_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0122_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0122_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0122_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0122_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0122_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()))).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)FrequencyPeriodEnum.YEAR)), MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), MapperS.of((Object)((Object)FrequencyPeriodEnum.WEEK)), MapperS.of((Object)((Object)FrequencyPeriodEnum.DAIL)), MapperS.of((Object)((Object)FrequencyPeriodEnum.QURT)), MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier())).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.lessThan((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)1000), (CardinalityOperator)CardinalityOperator.All)).and(ifThenElseResult);
                }
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod())).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.ADHO)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

