/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.quantity.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.WeatherUnitEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

@ImplementedBy(value=QuantityUnitOfMeasureRuleDefault.class)
public abstract class QuantityUnitOfMeasureRule
implements ReportFunction<NonNegativeQuantitySchedule, String> {
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public String evaluate(NonNegativeQuantitySchedule input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(NonNegativeQuantitySchedule var1);

    public static class QuantityUnitOfMeasureRuleDefault
    extends QuantityUnitOfMeasureRule {
        @Override
        protected String doEvaluate(NonNegativeQuantitySchedule input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, NonNegativeQuantitySchedule input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getUnit", measure -> measure.getUnit());
                }
                return item.map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
            });
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

