/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.valuation.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.GetValuation;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ValuationAmountRuleDefault.class)
public abstract class ValuationAmountRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected GetValuation getValuation;
    @Inject
    protected RoundToPrecision roundToPrecision;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ValuationAmountRuleDefault
    extends ValuationAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.getValuation.evaluate(input)).map("getAmount", valuation -> valuation.getAmount()).map("getValue", money -> money.getValue());
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.roundToPrecision.evaluate((BigDecimal)item.get(), Integer.valueOf(5), RoundingDirectionEnum.NEAREST)));
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg1.get())).get();
            return output;
        }
    }
}

