/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportablePricePeriodDefault.class)
public abstract class GetReportablePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version1.price.functions.GetReportablePricePeriod getReportablePricePeriod;

    public List<? extends PricePeriod> evaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
        List reportablePeriod;
        List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent, notation);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent var1, PriceNotationEnum var2);

    public static class GetReportablePricePeriodDefault
    extends GetReportablePricePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent, PriceNotationEnum notation) {
            reportablePeriod.addAll(this.toBuilder(this.getReportablePricePeriod.evaluate(reportableEvent, notation)));
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

