/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadNoFormatRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadNotationEnumRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionSpreadRuleDefault.class)
public abstract class PackageTransactionSpreadRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PackageTransactionSpreadNoFormatRule packageTransactionSpreadNoFormatRule;
    @Inject
    protected PackageTransactionSpreadNotationEnumRule packageTransactionSpreadNotationEnumRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionSpreadRuleDefault
    extends PackageTransactionSpreadRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder(this.priceFormatFromNotation.evaluate(this.packageTransactionSpreadNoFormatRule.evaluate(input), this.packageTransactionSpreadNotationEnumRule.evaluate(input)));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

