/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common;

import com.rosetta.model.lib.ModelReportId;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RegPaths {
    public static final Path INPUT_PATH = Paths.get("input", new String[0]);
    public static final Path OUTPUT_PATH = Paths.get("output", new String[0]);
    public static final Path CONFIG_PATH = Paths.get("config", new String[0]);
    public static final Path LOOKUP_PATH = Paths.get("lookup", new String[0]);
    public static final Path LEGACY_DATA_PATH = Paths.get("data", new String[0]);
    public static final String KEY_VALUE_FILE_NAME_SUFFIX = "-key-value.json";
    public static final String REPORT_FILE_NAME_SUFFIX = "-report.json";
    private final Path rootPath;
    private final Path input;
    private final Path output;
    private final Path config;
    private final Path lookup;

    public RegPaths(Path rootPath, Path input, Path output, Path config, Path lookup) {
        this.rootPath = rootPath;
        this.config = config;
        this.input = input;
        this.output = output;
        this.lookup = lookup;
    }

    public Path getRootRelativePath() {
        return this.rootPath;
    }

    public Path getConfigRelativePath() {
        return this.config;
    }

    public Path getInputRelativePath() {
        return this.input;
    }

    public Path getOutputRelativePath() {
        return this.output;
    }

    public Path getLookupRelativePath() {
        return this.lookup;
    }

    public static String directoryNameOfDataset(String datasetName) {
        return datasetName.replace(" ", "-").replace("_", "-").trim().toLowerCase();
    }

    public static String directoryName(ModelReportId id) {
        return id.joinRegulatoryReference("-").replace("_", "-").toLowerCase();
    }

    public static Path getOutputPath(Path outputPath, ModelReportId reportIdentifier) {
        return outputPath.resolve(RegPaths.directoryName(reportIdentifier));
    }

    public static Path getOutputDataSetPath(Path outputPath, ModelReportId reportIdentifier, String dataSetName) {
        return RegPaths.getOutputPath(outputPath, reportIdentifier).resolve(RegPaths.directoryNameOfDataset(dataSetName));
    }

    public static Path getInputDataSetPath(Path inputPath, String dataSetName) {
        return inputPath.resolve(RegPaths.directoryNameOfDataset(dataSetName));
    }

    public static Path getKeyValueExpectationFilePath(Path outputPath, ModelReportId reportIdentifier, String dataSetName, Path inputPath) {
        return RegPaths.getOutputDataSetPath(outputPath, reportIdentifier, dataSetName).resolve(inputPath.getFileName().toString().replace(".json", KEY_VALUE_FILE_NAME_SUFFIX));
    }
}

