/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ScopeReferenceHelper;
import com.regnosys.rosetta.common.util.PathUtils;
import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTemporaryKeyProcessStep
implements PostProcessStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateTemporaryKeyProcessStep.class);
    private final ReferenceConfig referenceConfig;

    public UpdateTemporaryKeyProcessStep(ReferenceConfig referenceConfig) {
        this.referenceConfig = referenceConfig;
    }

    public Integer getPriority() {
        return 2;
    }

    public String getName() {
        return "Update Temporary Key Processor";
    }

    public <T extends RosettaModelObject> PostProcessorReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaModelObjectBuilder builder = instance.toBuilder();
        ScopedKeyReferenceCollector collectedData = this.collectScopedKeyReferences(builder);
        this.updateReferences(collectedData.helper.getScopeToDataMap().values());
        return new ScopedReferenceReKeyPostProcessorReport(instance.build(), null);
    }

    private void updateReferences(Collection<ScopedData> values) {
        for (ScopedData scopedData : values) {
            HashMap<String, AtomicInteger> prefixIndexMap = new HashMap<String, AtomicInteger>();
            for (String keyValue : scopedData.keyAndReferences.keySet()) {
                KeyAndReferences keyAndReferences = (KeyAndReferences)scopedData.keyAndReferences.get(keyValue);
                LOGGER.debug("Updating scoped key/references for {}", (Object)keyValue);
                String prefix = keyValue.split("-")[0];
                int index = prefixIndexMap.computeIfAbsent(prefix, k -> new AtomicInteger(1)).getAndIncrement();
                String newKeyValue = String.format("%s-%d", prefix, index);
                for (GlobalKey.GlobalKeyBuilder key : keyAndReferences.keys) {
                    key.getOrCreateMeta().setKey(Collections.singletonList(Key.builder().setKeyValue(newKeyValue).setScope("DOCUMENT")));
                }
                for (ReferenceWithMeta.ReferenceWithMetaBuilder reference : keyAndReferences.references) {
                    reference.setReference((Reference)Reference.builder().setReference(newKeyValue).setScope("DOCUMENT"));
                }
            }
        }
    }

    private ScopedKeyReferenceCollector collectScopedKeyReferences(RosettaModelObjectBuilder builder) {
        RosettaPath path = RosettaPath.valueOf((String)builder.getType().getSimpleName());
        ScopedKeyReferenceCollector collector = new ScopedKeyReferenceCollector(this.referenceConfig);
        builder.process(path, (Processor)collector);
        return collector;
    }

    private static class ScopedKeyReferenceCollector
    extends SimpleProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(ScopedKeyReferenceCollector.class);
        private static final String TEMPORARY_KEY_REGEX = "[a-zA-Z]*-\\$[0-9]*";
        private final ScopeReferenceHelper<ScopedData> helper;

        public ScopedKeyReferenceCollector(ReferenceConfig referenceConfig) {
            this.helper = new ScopeReferenceHelper<ScopedData>(referenceConfig, () -> new ScopedData());
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
            this.helper.collectScopePath(path, rosettaType);
            if (instance instanceof FieldWithMeta) {
                FieldWithMeta fieldWithMeta = (FieldWithMeta)instance;
                if (fieldWithMeta instanceof ReferenceWithMeta.ReferenceWithMetaBuilder) {
                    ReferenceWithMeta.ReferenceWithMetaBuilder referenceWithMeta = (ReferenceWithMeta.ReferenceWithMetaBuilder)fieldWithMeta;
                    Optional.ofNullable(referenceWithMeta.getReference()).map(Reference::getReference).filter(v -> v.matches(TEMPORARY_KEY_REGEX)).ifPresent(referenceValue -> {
                        ScopedData scopedData = this.helper.getDataForModelPath(PathUtils.toPath(path));
                        LOGGER.debug("Collecting reference {} for type {} at path {}", new Object[]{referenceValue, referenceWithMeta.getValueType().getName(), path});
                        scopedData.addReference((String)referenceValue, (ReferenceWithMeta.ReferenceWithMetaBuilder<?>)referenceWithMeta);
                    });
                } else if (fieldWithMeta instanceof GlobalKey.GlobalKeyBuilder) {
                    GlobalKey.GlobalKeyBuilder globalKeyBuilder = (GlobalKey.GlobalKeyBuilder)fieldWithMeta;
                    Optional.ofNullable(globalKeyBuilder.getMeta()).map(GlobalKeyFields.GlobalKeyFieldsBuilder::getKey).orElse(Collections.emptyList()).stream().map(Key::getKeyValue).filter(Objects::nonNull).findFirst().filter(v -> v.matches(TEMPORARY_KEY_REGEX)).ifPresent(keyValue -> {
                        ScopedData scopedData = this.helper.getDataForModelPath(PathUtils.toPath(path));
                        LOGGER.debug("Collecting key {} for type {} at path {}", new Object[]{keyValue, fieldWithMeta.getValueType().getName(), path});
                        scopedData.addKey((String)keyValue, globalKeyBuilder);
                    });
                }
            }
            return true;
        }

        public Processor.Report report() {
            return null;
        }
    }

    public static class ScopedReferenceReKeyPostProcessorReport<T extends RosettaModelObject>
    implements PostProcessorReport {
        private final T instance;

        private ScopedReferenceReKeyPostProcessorReport(T instance) {
            this.instance = instance;
        }

        public T getResultObject() {
            return this.instance;
        }

        /* synthetic */ ScopedReferenceReKeyPostProcessorReport(RosettaModelObject x0, 1 x1) {
            this(x0);
        }
    }

    private static class ScopedData {
        private final Map<String, KeyAndReferences> keyAndReferences = new LinkedHashMap<String, KeyAndReferences>();

        private ScopedData() {
        }

        void addKey(String keyValue, GlobalKey.GlobalKeyBuilder key) {
            this.keyAndReferences.compute(keyValue, (k, oldValue) -> {
                KeyAndReferences newValue = oldValue == null ? new KeyAndReferences() : oldValue;
                newValue.keys.add(key);
                return newValue;
            });
        }

        void addReference(String keyValue, ReferenceWithMeta.ReferenceWithMetaBuilder<?> reference) {
            this.keyAndReferences.compute(keyValue, (k, oldValue) -> {
                KeyAndReferences newValue = oldValue == null ? new KeyAndReferences() : oldValue;
                newValue.references.add(reference);
                return newValue;
            });
        }
    }

    private static class KeyAndReferences {
        private final List<GlobalKey.GlobalKeyBuilder> keys = new ArrayList<GlobalKey.GlobalKeyBuilder>();
        private final List<ReferenceWithMeta.ReferenceWithMetaBuilder<?>> references = new ArrayList();

        private KeyAndReferences() {
        }
    }
}

