/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.regnosys.rosetta.formatting2.FormattingOptionsService;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatterRequestWithDefaultPreferencesProvider
implements jakarta.inject.Provider<FormatterRequest>,
Provider<FormatterRequest> {
    private final ITypedPreferenceValues defaultPreferences;

    @Inject
    public FormatterRequestWithDefaultPreferencesProvider(FormattingOptionsService optionsService) {
        this.defaultPreferences = optionsService.getDefaultPreferences();
    }

    public FormatterRequest get() {
        return new FormatterRequestWithDefaultPreferences(this.defaultPreferences);
    }

    private static class FormatterRequestWithDefaultPreferences
    extends FormatterRequest {
        private static Logger LOGGER = LoggerFactory.getLogger(FormatterRequestWithDefaultPreferences.class);
        private final ITypedPreferenceValues defaultPreferences;

        public FormatterRequestWithDefaultPreferences(ITypedPreferenceValues defaultPreferences) {
            this.defaultPreferences = defaultPreferences;
            super.setPreferences(defaultPreferences);
        }

        public FormatterRequest setPreferences(ITypedPreferenceValues preferences) {
            return super.setPreferences(this.overrideDefaultPreferences(preferences));
        }

        private ITypedPreferenceValues overrideDefaultPreferences(ITypedPreferenceValues preferences) {
            if (preferences == null) {
                return this.defaultPreferences;
            }
            Map<String, String> overrideValues = this.getValuesMapIfPossible(preferences);
            if (overrideValues == null) {
                LOGGER.error("Could not compute preference values to override from " + String.valueOf(preferences), (Throwable)new Exception());
                return this.defaultPreferences;
            }
            return new MapBasedPreferenceValues((IPreferenceValues)this.defaultPreferences, overrideValues);
        }

        private Map<String, String> getValuesMapIfPossible(ITypedPreferenceValues preferences) {
            while (!(preferences instanceof MapBasedPreferenceValues) || ((MapBasedPreferenceValues)preferences).getDelegate() != null) {
                if (preferences instanceof TypedPreferenceValues && ((TypedPreferenceValues)preferences).getDelegate() instanceof ITypedPreferenceValues) {
                    preferences = (ITypedPreferenceValues)((TypedPreferenceValues)preferences).getDelegate();
                    continue;
                }
                if (preferences instanceof MapBasedPreferenceValues && ((MapBasedPreferenceValues)preferences).getDelegate() instanceof ITypedPreferenceValues) {
                    MapBasedPreferenceValues preferencesWithDelegate = (MapBasedPreferenceValues)preferences;
                    Map<String, String> delegateValues = this.getValuesMapIfPossible((ITypedPreferenceValues)preferencesWithDelegate.getDelegate());
                    if (delegateValues == null) {
                        return null;
                    }
                    Map<String, String> mergedValues = Stream.of(delegateValues.entrySet(), preferencesWithDelegate.getValues().entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
                    return mergedValues;
                }
                return null;
            }
            MapBasedPreferenceValues preferencesWithoutDelegate = (MapBasedPreferenceValues)preferences;
            return preferencesWithoutDelegate.getValues();
        }
    }
}

