/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.expression.ExpressionFactory;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.BuiltinAnnotationWithPath;
import com.regnosys.rosetta.rosetta.simple.Condition;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class ImplicitVariableUtil {
    public RosettaImplicitVariable getDefaultImplicitVariable() {
        RosettaImplicitVariable def = ExpressionFactory.eINSTANCE.createRosettaImplicitVariable();
        def.setName("item");
        def.setGenerated(true);
        return def;
    }

    public Optional<? extends EObject> findContainerDefiningImplicitVariable(EObject context) {
        Iterable containers = EcoreUtil2.getAllContainers((EObject)context);
        EObject prev = context;
        for (EObject container : containers) {
            if (container instanceof Condition) {
                Condition cond = (Condition)container;
                RosettaTypeWithConditions enclosingType = cond.getEnclosingType();
                if (enclosingType != null) {
                    return Optional.of(enclosingType);
                }
            } else if (container instanceof RosettaFunctionalOperation) {
                RosettaFunctionalOperation op = (RosettaFunctionalOperation)container;
                InlineFunction f = op.getFunction();
                if (f != null && f.equals(prev) && f.getParameters().isEmpty()) {
                    return Optional.of(container);
                }
            } else {
                Attribute attr;
                if (container instanceof RosettaRule) {
                    return Optional.of(container);
                }
                if (container instanceof SwitchCaseOrDefault) {
                    SwitchCaseOrDefault c = (SwitchCaseOrDefault)container;
                    if (!(c.isDefault() || c.getGuard().getChoiceOptionGuard() == null && c.getGuard().getDataGuard() == null)) {
                        return Optional.of(container);
                    }
                } else if (container instanceof BuiltinAnnotationWithPath && (attr = (Attribute)EcoreUtil2.getContainerOfType((EObject)container, Attribute.class)) != null) {
                    return Optional.of(attr);
                }
            }
            prev = container;
        }
        return Optional.empty();
    }

    public boolean implicitVariableExistsInContext(EObject context) {
        return this.findContainerDefiningImplicitVariable(context).isPresent();
    }
}

