/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class EnumValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;

    @Check
    public void checkEnumNameIsCapitalized(RosettaEnumeration enumeration) {
        if (Character.isLowerCase(enumeration.getName().charAt(0))) {
            this.warning("Enumeration name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkCyclicExtensions(RosettaEnumeration enumeration) {
        RosettaEnumeration p = enumeration.getParent();
        if (p != null) {
            ArrayList<RosettaEnumeration> path = new ArrayList<RosettaEnumeration>();
            path.add(enumeration);
            HashSet<RosettaEnumeration> visited = new HashSet<RosettaEnumeration>();
            visited.add(enumeration);
            if (this.hasCyclicExtension(p, path, visited)) {
                String pathString = path.stream().map(e -> e.getName()).collect(Collectors.joining(" extends "));
                this.error("Cyclic extension: " + pathString, enumeration, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_ENUMERATION__PARENT);
            }
        }
    }

    private boolean hasCyclicExtension(RosettaEnumeration current, List<RosettaEnumeration> path, Set<RosettaEnumeration> visited) {
        path.add(current);
        if (visited.add(current) && current.getParent() != null ? this.hasCyclicExtension(current.getParent(), path, visited) : path.get(0).equals(path.get(path.size() - 1))) {
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    @Check
    public void checkEnumValuesAreUnique(RosettaEnumeration enumeration) {
        HashSet<String> usedNames = new HashSet<String>();
        if (enumeration.getParent() != null) {
            this.ecoreUtil.getAllEnumValues(enumeration.getParent()).forEach(v -> usedNames.add(v.getName()));
        }
        for (RosettaEnumValue value : enumeration.getEnumValues()) {
            if (usedNames.add(value.getName())) continue;
            this.error("Duplicate enum value '" + value.getName() + "'", value, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }
}

