package drr.enrichment.upi.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.Frequency;
import cdm.base.datetime.Period;
import cdm.base.datetime.PeriodEnum;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.asset.rates.InflationRateIndexEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.Observable;
import cdm.observable.asset.Price;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.PhysicalSettlementTerms;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.common.settlement.metafields.ReferenceWithMetaResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_BaseProduct_CrossCurrency;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquitySwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Fra;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Inflation;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_Basket;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_Index;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_IndexTranche;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_Loan;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwap_SingleName;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwaption;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.qualification.functions.Qualify_ForeignExchange_VanillaOption;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_CrossCurrency_Basis;
import cdm.product.qualification.functions.Qualify_InterestRate_CrossCurrency_FixedFixed;
import cdm.product.qualification.functions.Qualify_InterestRate_CrossCurrency_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_Fra;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_Basis;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_Basis_OIS;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_FixedFixed;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_FixedFloat_OIS;
import cdm.product.qualification.functions.Qualify_InterestRate_IRSwap_FixedFloat_ZeroCoupon;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_DebtOption;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.qualification.functions.Qualify_SubProduct_Basis;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStrike;
import cdm.product.template.OptionStyle;
import cdm.product.template.OptionTypeEnum;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.FXLeg1;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg1;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.GetLeg2ResolvablePriceQuantity;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.InterestRateLeg1CapFloor;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsCapFloor;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.SettlementTermsLeg1;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.common.util.functions.ReplaceAll;
import drr.regulation.common.util.functions.StringContains;
import drr.standards.iosco.cde.base.quantity.reports.FXNotionalCurrencyRule;
import drr.standards.iosco.cde.base.quantity.reports.InterestRateNotionalCurrencyRule;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbBaseProduct;
import drr.standards.iosco.upi.AnnaDsbContractSpecificationEnum;
import drr.standards.iosco.upi.AnnaDsbDebtSeniorityEnum;
import drr.standards.iosco.upi.AnnaDsbDeliveryTypeEnum;
import drr.standards.iosco.upi.AnnaDsbHeader;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbLevelEnum;
import drr.standards.iosco.upi.AnnaDsbNotionalScheduleEnum;
import drr.standards.iosco.upi.AnnaDsbOptionExerciseStyleEnum;
import drr.standards.iosco.upi.AnnaDsbOptionTypeEnum;
import drr.standards.iosco.upi.AnnaDsbOtherLegUnderlierIDSourceEnum;
import drr.standards.iosco.upi.AnnaDsbOtherLegUnderlying;
import drr.standards.iosco.upi.AnnaDsbOtherUnderlierIDSourceEnum;
import drr.standards.iosco.upi.AnnaDsbPlaceofSettlementEnum;
import drr.standards.iosco.upi.AnnaDsbReturnorPayoutTriggerEnum;
import drr.standards.iosco.upi.AnnaDsbUnderlierIDSourceEnum;
import drr.standards.iosco.upi.AnnaDsbUnderlying;
import drr.standards.iosco.upi.AnnaDsbUnderlyingAssetTypeEnum;
import drr.standards.iosco.upi.AnnaDsbUnderlyingInstrumentIndexTermUnitEnum;
import drr.standards.iosco.upi.AnnaDsbUnderlyingIssuerTypeEnum;
import drr.standards.iosco.upi.AnnaDsbUpiRequest;
import drr.standards.iosco.upi.AnnaDsbUseCaseEnum;
import drr.standards.iosco.upi.AnnaDsbValuationMethodorTriggerEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_AnnaDsbUpiRequestFromReportableEventAndUnderlying.Create_AnnaDsbUpiRequestFromReportableEventAndUnderlyingDefault.class)
public abstract class Create_AnnaDsbUpiRequestFromReportableEventAndUnderlying implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Compute_IndexTermValue compute_IndexTermValue;
	@Inject protected Compute_NotionalScheduleType compute_NotionalScheduleType;
	@Inject protected ConvertCurrency convertCurrency;
	@Inject protected Create_AnnaDsbUpiRequestBaseProductForCommodity create_AnnaDsbUpiRequestBaseProductForCommodity;
	@Inject protected Create_AnnaDsbUpiRequestOtherLegUnderlyingForRate create_AnnaDsbUpiRequestOtherLegUnderlyingForRate;
	@Inject protected Create_AnnaDsbUpiRequestUnderlyingForCredit create_AnnaDsbUpiRequestUnderlyingForCredit;
	@Inject protected Create_AnnaDsbUpiRequestUnderlyingForCreditNonStandard create_AnnaDsbUpiRequestUnderlyingForCreditNonStandard;
	@Inject protected Create_AnnaDsbUpiRequestUnderlyingForRate create_AnnaDsbUpiRequestUnderlyingForRate;
	@Inject protected DebtSeniority debtSeniority;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXNotionalCurrencyRule fXNotionalCurrencyRule;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected FloatingRateIndex floatingRateIndex;
	@Inject protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
	@Inject protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
	@Inject protected InflationRateIndex inflationRateIndex;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg1CapFloor interestRateLeg1CapFloor;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected InterestRateNotionalCurrencyRule interestRateNotionalCurrencyRule;
	@Inject protected IsCallOption isCallOption;
	@Inject protected IsCap isCap;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFloor isFloor;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsOption isOption0;
	@Inject protected IsPutOption isPutOption;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_BaseProduct_CrossCurrency qualify_BaseProduct_CrossCurrency;
	@Inject protected Qualify_BaseProduct_EquitySwap qualify_BaseProduct_EquitySwap;
	@Inject protected Qualify_BaseProduct_Fra qualify_BaseProduct_Fra;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected Qualify_BaseProduct_Inflation qualify_BaseProduct_Inflation;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_CreditDefaultSwap_Basket qualify_CreditDefaultSwap_Basket;
	@Inject protected Qualify_CreditDefaultSwap_Index qualify_CreditDefaultSwap_Index;
	@Inject protected Qualify_CreditDefaultSwap_IndexTranche qualify_CreditDefaultSwap_IndexTranche;
	@Inject protected Qualify_CreditDefaultSwap_Loan qualify_CreditDefaultSwap_Loan;
	@Inject protected Qualify_CreditDefaultSwap_SingleName qualify_CreditDefaultSwap_SingleName;
	@Inject protected Qualify_CreditDefaultSwaption qualify_CreditDefaultSwaption;
	@Inject protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
	@Inject protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
	@Inject protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
	@Inject protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;
	@Inject protected Qualify_ForeignExchange_VanillaOption qualify_ForeignExchange_VanillaOption;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_CrossCurrency_Basis qualify_InterestRate_CrossCurrency_Basis;
	@Inject protected Qualify_InterestRate_CrossCurrency_FixedFixed qualify_InterestRate_CrossCurrency_FixedFixed;
	@Inject protected Qualify_InterestRate_CrossCurrency_FixedFloat qualify_InterestRate_CrossCurrency_FixedFloat;
	@Inject protected Qualify_InterestRate_Fra qualify_InterestRate_Fra;
	@Inject protected Qualify_InterestRate_IRSwap_Basis qualify_InterestRate_IRSwap_Basis;
	@Inject protected Qualify_InterestRate_IRSwap_Basis_OIS qualify_InterestRate_IRSwap_Basis_OIS;
	@Inject protected Qualify_InterestRate_IRSwap_FixedFixed qualify_InterestRate_IRSwap_FixedFixed;
	@Inject protected Qualify_InterestRate_IRSwap_FixedFloat qualify_InterestRate_IRSwap_FixedFloat;
	@Inject protected Qualify_InterestRate_IRSwap_FixedFloat_OIS qualify_InterestRate_IRSwap_FixedFloat_OIS;
	@Inject protected Qualify_InterestRate_IRSwap_FixedFloat_ZeroCoupon qualify_InterestRate_IRSwap_FixedFloat_ZeroCoupon;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_YearOn_Year qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;
	@Inject protected Qualify_InterestRate_Option_DebtOption qualify_InterestRate_Option_DebtOption;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected Qualify_SubProduct_Basis qualify_SubProduct_Basis;
	@Inject protected ReplaceAll replaceAll;
	@Inject protected SettlementTermsLeg1 settlementTermsLeg1;
	@Inject protected StringContains stringContains;
	@Inject protected TranslateAssetClass translateAssetClass;
	@Inject protected TranslatePeriodEnum translatePeriodEnum;
	@Inject protected TranslatePeriodExtendedEnum translatePeriodExtendedEnum;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return request 
	*/
	public AnnaDsbUpiRequest evaluate(ReportableEvent reportableEvent) {
		AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder requestBuilder = doEvaluate(reportableEvent);
		
		final AnnaDsbUpiRequest request;
		if (requestBuilder == null) {
			request = null;
		} else {
			request = requestBuilder.build();
			objectValidator.validate(AnnaDsbUpiRequest.class, request);
		}
		
		return request;
	}

	protected abstract AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Trade> tradeForEvent(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends FieldWithMetaString> isdaTaxonomy(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> isSwaption(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> isOption1(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbUseCaseEnum> useCase(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends SettlementTerms> settlementTerms(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbNotionalScheduleEnum> leg1(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbNotionalScheduleEnum> leg2(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends InterestRatePayout> interestRatePayoutFloatingLeg(ReportableEvent reportableEvent);

	protected abstract MapperS<AnnaDsbInstrumentTypeEnum> instrumentType(ReportableEvent reportableEvent);

	public static class Create_AnnaDsbUpiRequestFromReportableEventAndUnderlyingDefault extends Create_AnnaDsbUpiRequestFromReportableEventAndUnderlying {
		@Override
		protected AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder doEvaluate(ReportableEvent reportableEvent) {
			AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder request = AnnaDsbUpiRequest.builder();
			return assignOutput(request, reportableEvent);
		}
		
		protected AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder assignOutput(AnnaDsbUpiRequest.AnnaDsbUpiRequestBuilder request, ReportableEvent reportableEvent) {
			final AnnaDsbAssetClassEnum ifThenElseResult0;
			if (exists(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass())).getOrDefault(false)) {
				final FieldWithMetaAssetClassEnum fieldWithMetaAssetClassEnum0 = product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).get();
				ifThenElseResult0 = translateAssetClass.evaluate((fieldWithMetaAssetClassEnum0 == null ? null : fieldWithMetaAssetClassEnum0.getValue()));
			} else if (isSwaption(reportableEvent).getOrDefault(false)) {
				final FieldWithMetaAssetClassEnum fieldWithMetaAssetClassEnum1 = tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).get();
				ifThenElseResult0 = translateAssetClass.evaluate((fieldWithMetaAssetClassEnum1 == null ? null : fieldWithMetaAssetClassEnum1.getValue()));
			} else {
				ifThenElseResult0 = null;
			}
			request
				.setHeader(AnnaDsbHeader.builder()
					.setLevel(AnnaDsbLevelEnum.UPI)
					.setAssetClass(ifThenElseResult0)
					.setUseCase(useCase(reportableEvent).get())
					.setInstrumentType(instrumentType(reportableEvent).get())
					.build());
			
			final MapperS<? extends Product> thenArg0 = product(reportableEvent);
			final Boolean boolean0 = isOption0.evaluate(thenArg0.get());
			final MapperS<AnnaDsbOptionExerciseStyleEnum> ifThenElseResult1;
			if ((boolean0 == null ? false : boolean0)) {
				ifThenElseResult1 = MapperS.of(thenArg0.<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle())
					.mapSingleToItem(item -> {
						if (exists(item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(false)) {
							return MapperS.of(AnnaDsbOptionExerciseStyleEnum.AMER);
						}
						if (exists(item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(false)) {
							return MapperS.of(AnnaDsbOptionExerciseStyleEnum.EURO);
						}
						if (exists(item.<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(false)) {
							return MapperS.of(AnnaDsbOptionExerciseStyleEnum.BERM);
						}
						return MapperS.<AnnaDsbOptionExerciseStyleEnum>ofNull();
					});
			} else {
				ifThenElseResult1 = MapperS.<AnnaDsbOptionExerciseStyleEnum>ofNull();
			}
			request
				.getOrCreateAttributes()
				.setOptionExerciseStyle(ifThenElseResult1.get());
			
			final MapperS<? extends Product> thenArg1 = product(reportableEvent);
			final MapperS<AnnaDsbOptionTypeEnum> ifThenElseResult2;
			if (areEqual(thenArg1.<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionTypeEnum>map("getOptionType", optionPayout -> optionPayout.getOptionType()), MapperS.of(OptionTypeEnum.STRADDLE), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(AnnaDsbOptionTypeEnum.OPTL);
			} else if (ComparisonResult.of(MapperS.of(isFloor.evaluate(thenArg1.get()))).or(ComparisonResult.of(MapperS.of(isPutOption.evaluate(thenArg1.get())))).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(AnnaDsbOptionTypeEnum.PUTO);
			} else if (ComparisonResult.of(MapperS.of(isCallOption.evaluate(thenArg1.get()))).or(ComparisonResult.of(MapperS.of(isCap.evaluate(thenArg1.get())))).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(AnnaDsbOptionTypeEnum.CALL);
			} else {
				ifThenElseResult2 = MapperS.<AnnaDsbOptionTypeEnum>ofNull();
			}
			request
				.getOrCreateAttributes()
				.setOptionType(ifThenElseResult2.get());
			
			final Boolean boolean1 = qualify_InterestRate_Option_Swaption.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
			final MapperS<InterestRatePayout> thenArg2;
			if ((boolean1 == null ? false : boolean1)) {
				thenArg2 = MapperS.of(interestRateLeg1.evaluate(underlierForProduct.evaluate(product(reportableEvent).get())));
			} else {
				final Boolean boolean2 = qualify_AssetClass_InterestRate.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
				if ((boolean2 == null ? false : boolean2)) {
					thenArg2 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()));
				} else {
					thenArg2 = MapperS.<InterestRatePayout>ofNull();
				}
			}
			final MapperS<String> ifThenElseResult3;
			if (exists(thenArg2.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString0 = thenArg2.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				ifThenElseResult3 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())));
			} else if (exists(thenArg2.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference())).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString1 = thenArg2.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference()).<ResolvablePriceQuantity>map("Type coercion", referenceWithMetaResolvablePriceQuantity0 -> referenceWithMetaResolvablePriceQuantity0 == null ? null : referenceWithMetaResolvablePriceQuantity0.getValue()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				ifThenElseResult3 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())));
			} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT_OPTION), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT), CardinalityOperator.All)).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString2 = tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
					.first().<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				ifThenElseResult3 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue())));
			} else {
				ifThenElseResult3 = MapperS.<String>ofNull();
			}
			request
				.getOrCreateAttributes()
				.setNotionalCurrency(ifThenElseResult3.get());
			
			String ifThenElseResult4 = null;
			if (ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_FixedFloat.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_FixedFixed.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_Basis.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
				ifThenElseResult4 = interestRateNotionalCurrencyRule.evaluate(interestRateLeg2.evaluate(product(reportableEvent).get()));
			}
			request
				.getOrCreateAttributes()
				.setOtherNotionalCurrency(ifThenElseResult4);
			
			final String ifThenElseResult7;
			if (ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(product(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(product(reportableEvent).get())))).getOrDefault(false)) {
				final MapperC<ReferenceWithMetaProductIdentifier> thenArg3 = MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())
					.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.UPI), CardinalityOperator.All).get());
				final MapperS<ReferenceWithMetaProductIdentifier> thenArg4 = thenArg3
					.first();
				final FieldWithMetaString fieldWithMetaString3 = thenArg4.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
				ifThenElseResult7 = fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue();
			} else if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(product(reportableEvent).get())))).getOrDefault(false)) {
				final MapperS<Cashflow> thenArg5 = MapperS.of(fXLeg1.evaluate(product(reportableEvent).get()));
				final MapperS<String> ifThenElseResult5;
				if (exists(thenArg5.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).getOrDefault(false)) {
					final FieldWithMetaString fieldWithMetaString4 = thenArg5.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
					ifThenElseResult5 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString4 == null ? null : fieldWithMetaString4.getValue())));
				} else if (exists(thenArg5.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference())).getOrDefault(false)) {
					final FieldWithMetaString fieldWithMetaString5 = thenArg5.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference()).<ResolvablePriceQuantity>map("Type coercion", referenceWithMetaResolvablePriceQuantity1 -> referenceWithMetaResolvablePriceQuantity1 == null ? null : referenceWithMetaResolvablePriceQuantity1.getValue()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
					ifThenElseResult5 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString5 == null ? null : fieldWithMetaString5.getValue())));
				} else {
					ifThenElseResult5 = MapperS.<String>ofNull();
				}
				ifThenElseResult7 = ifThenElseResult5.get();
			} else if (ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				final MapperS<Cashflow> thenArg6 = MapperS.of(fXSwapLeg1.evaluate(product(reportableEvent).get()));
				final MapperS<String> ifThenElseResult6;
				if (exists(thenArg6.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).getOrDefault(false)) {
					final FieldWithMetaString fieldWithMetaString6 = thenArg6.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule4 -> referenceWithMetaNonNegativeQuantitySchedule4 == null ? null : referenceWithMetaNonNegativeQuantitySchedule4.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
					ifThenElseResult6 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString6 == null ? null : fieldWithMetaString6.getValue())));
				} else if (exists(thenArg6.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference())).getOrDefault(false)) {
					final FieldWithMetaString fieldWithMetaString7 = thenArg6.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaResolvablePriceQuantity>map("getQuantityReference", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityReference()).<ResolvablePriceQuantity>map("Type coercion", referenceWithMetaResolvablePriceQuantity2 -> referenceWithMetaResolvablePriceQuantity2 == null ? null : referenceWithMetaResolvablePriceQuantity2.getValue()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule5 -> referenceWithMetaNonNegativeQuantitySchedule5 == null ? null : referenceWithMetaNonNegativeQuantitySchedule5.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
					ifThenElseResult6 = MapperS.of(convertCurrency.evaluate((fieldWithMetaString7 == null ? null : fieldWithMetaString7.getValue())));
				} else {
					ifThenElseResult6 = MapperS.<String>ofNull();
				}
				ifThenElseResult7 = ifThenElseResult6.get();
			} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				final MapperC<ReferenceWithMetaProductIdentifier> thenArg7 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())
					.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
				if (thenArg7
					.first()
					.mapSingleToItem(item -> exists(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).asMapper()).getOrDefault(false)) {
					final MapperC<ReferenceWithMetaProductIdentifier> thenArg8 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())
						.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
					final FieldWithMetaString fieldWithMetaString8 = thenArg8
						.first()
						.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).get();
					ifThenElseResult7 = fieldWithMetaString8 == null ? null : fieldWithMetaString8.getValue();
				} else {
					ifThenElseResult7 = "OTHER";
				}
			} else {
				final Boolean boolean3 = qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get());
				if ((boolean3 == null ? false : boolean3)) {
					final MapperC<ReferenceWithMetaProductIdentifier> thenArg9 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())
						.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
					if (thenArg9
						.first()
						.mapSingleToItem(item -> exists(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).asMapper()).getOrDefault(false)) {
						final MapperC<ReferenceWithMetaProductIdentifier> thenArg10 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())
							.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
						final FieldWithMetaString fieldWithMetaString9 = thenArg10
							.first()
							.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier == null ? null : _referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).get();
						ifThenElseResult7 = fieldWithMetaString9 == null ? null : fieldWithMetaString9.getValue();
					} else {
						ifThenElseResult7 = null;
					}
				} else if (exists(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
					final MapperS<InterestRatePayout> thenArg11 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()));
					ifThenElseResult7 = thenArg11
						.mapSingleToItem(item -> MapperS.of(floatingRateIndex.evaluate(item.get()))).get();
				} else if (exists(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
					final MapperS<InterestRatePayout> thenArg12 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()));
					ifThenElseResult7 = thenArg12
						.mapSingleToItem(item -> MapperS.of(inflationRateIndex.evaluate(item.get())).map("to-string", InflationRateIndexEnum::toDisplayString)).get();
				} else if (exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
					final MapperS<InterestRatePayout> thenArg13 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()));
					ifThenElseResult7 = thenArg13
						.mapSingleToItem(item -> MapperS.of(floatingRateIndex.evaluate(item.get()))).get();
				} else if (exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
					final MapperS<InterestRatePayout> thenArg14 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()));
					ifThenElseResult7 = thenArg14
						.mapSingleToItem(item -> MapperS.of(inflationRateIndex.evaluate(item.get())).map("to-string", InflationRateIndexEnum::toDisplayString)).get();
				} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT_OPTION), CardinalityOperator.All).getOrDefault(false)) {
					final MapperC<FieldWithMetaProductIdentifier> thenArg15 = tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaProductIdentifier>mapC("getProductIdentifier", observable -> observable.getProductIdentifier())
						.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier == null ? null : fieldWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).get());
					final FieldWithMetaString fieldWithMetaString10 = thenArg15
						.first()
						.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier == null ? null : fieldWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).get();
					ifThenElseResult7 = fieldWithMetaString10 == null ? null : fieldWithMetaString10.getValue();
				} else {
					ifThenElseResult7 = null;
				}
			}
			request
				.getOrCreateAttributes()
				.setUnderlierID(ifThenElseResult7);
			
			final AnnaDsbUnderlierIDSourceEnum ifThenElseResult8;
			if (ComparisonResult.of(MapperS.of(qualify_AssetClass_InterestRate.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(exists(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).or(exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()))).or(exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())))).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
				ifThenElseResult8 = AnnaDsbUnderlierIDSourceEnum.FPML;
			} else if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult8 = AnnaDsbUnderlierIDSourceEnum.CCY;
			} else if (ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwaption.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(economicTerms(reportableEvent).get())))).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.SINGLE_NAME_SWAPTION), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult8 = AnnaDsbUnderlierIDSourceEnum.UPI;
			} else {
				final Boolean boolean4 = qualify_InterestRate_Option_DebtOption.evaluate(economicTerms(reportableEvent).get());
				if ((boolean4 == null ? false : boolean4)) {
					ifThenElseResult8 = AnnaDsbUnderlierIDSourceEnum.ISIN;
				} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
					ifThenElseResult8 = AnnaDsbUnderlierIDSourceEnum.COMM;
				} else {
					ifThenElseResult8 = null;
				}
			}
			request
				.getOrCreateAttributes()
				.setUnderlierIDSource(ifThenElseResult8);
			
			final MapperS<InterestRatePayout> thenArg16;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INFLATION_SWAP), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).getOrDefault(false)) {
				thenArg16 = MapperS.<InterestRatePayout>ofNull();
			} else {
				final Boolean boolean5 = qualify_SubProduct_Basis.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
				if ((boolean5 == null ? false : boolean5)) {
					thenArg16 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()));
				} else {
					thenArg16 = MapperS.<InterestRatePayout>ofNull();
				}
			}
			request
				.getOrCreateAttributes()
				.setOtherLegUnderlierID(thenArg16
					.mapSingleToItem(item -> MapperS.of(floatingRateIndex.evaluate(item.get()))).get());
			
			final String ifThenElseResult9;
			if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(product(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult9 = convertCurrency.evaluate(fXNotionalCurrencyRule.evaluate(fXLeg2.evaluate(product(reportableEvent).get())));
			} else if (ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult9 = convertCurrency.evaluate(fXNotionalCurrencyRule.evaluate(fXSwapLeg2.evaluate(product(reportableEvent).get())));
			} else {
				ifThenElseResult9 = null;
			}
			request
				.getOrCreateAttributes()
				.setOtherUnderlierID(ifThenElseResult9);
			
			AnnaDsbOtherUnderlierIDSourceEnum ifThenElseResult10 = null;
			if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult10 = AnnaDsbOtherUnderlierIDSourceEnum.CCY;
			}
			request
				.getOrCreateAttributes()
				.setOtherUnderlierIDSource(ifThenElseResult10);
			
			final AnnaDsbOtherLegUnderlierIDSourceEnum ifThenElseResult11;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INFLATION_SWAP), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult11 = null;
			} else {
				final Boolean boolean6 = qualify_SubProduct_Basis.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
				if ((boolean6 == null ? false : boolean6)) {
					ifThenElseResult11 = AnnaDsbOtherLegUnderlierIDSourceEnum.FPML;
				} else {
					ifThenElseResult11 = null;
				}
			}
			request
				.getOrCreateAttributes()
				.setOtherLegUnderlierIDSource(ifThenElseResult11);
			
			final AnnaDsbDeliveryTypeEnum ifThenElseResult12;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NDF), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NDO), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult12 = null;
			} else {
				final Boolean boolean7 = qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get());
				if ((boolean7 == null ? false : boolean7)) {
					ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.CASH;
				} else {
					final Boolean boolean8 = qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get());
					if ((boolean8 == null ? false : boolean8)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.PHYS;
					} else if (areEqual(settlementTerms(reportableEvent).<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.CASH;
					} else if (areEqual(settlementTerms(reportableEvent).<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH_OR_PHYSICAL), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.OPTL;
					} else if (areEqual(settlementTerms(reportableEvent).<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.PHYSICAL), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.PHYS;
					} else if (areEqual(settlementTerms(reportableEvent).<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.ELECTION), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.OPTL;
					} else if (notExists(settlementTerms(reportableEvent).<PhysicalSettlementTerms>map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).and(exists(settlementTerms(reportableEvent).<CashSettlementTerms>mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.CASH;
					} else if (exists(settlementTerms(reportableEvent).<PhysicalSettlementTerms>map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).and(exists(settlementTerms(reportableEvent).<CashSettlementTerms>mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.OPTL;
					} else if (exists(settlementTerms(reportableEvent).<PhysicalSettlementTerms>map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).and(notExists(settlementTerms(reportableEvent).<CashSettlementTerms>mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.PHYS;
					} else if (areEqual(instrumentType(reportableEvent), MapperS.of(AnnaDsbInstrumentTypeEnum.OPTION), CardinalityOperator.All).or(areEqual(instrumentType(reportableEvent), MapperS.of(AnnaDsbInstrumentTypeEnum.FORWARD), CardinalityOperator.All)).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.PHYS;
					} else if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
						ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.PHYS;
					} else {
						final Boolean boolean9 = qualify_AssetClass_Credit.evaluate(economicTerms(reportableEvent).get());
						if ((boolean9 == null ? false : boolean9)) {
							ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.OPTL;
						} else {
							ifThenElseResult12 = AnnaDsbDeliveryTypeEnum.CASH;
						}
					}
				}
			}
			request
				.getOrCreateAttributes()
				.setDeliveryType(ifThenElseResult12);
			
			final MapperS<SettlementTerms> thenArg17;
			if (ComparisonResult.of(MapperS.of(qualify_AssetClass_InterestRate.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Credit.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(economicTerms(reportableEvent).get())))).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.VANILLA_OPTION), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.FORWARD), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.FX_SWAP), CardinalityOperator.All)).getOrDefault(false)) {
				thenArg17 = MapperS.<SettlementTerms>ofNull();
			} else {
				thenArg17 = MapperS.of(settlementTermsLeg1.evaluate(product(reportableEvent).get()));
			}
			request
				.getOrCreateAttributes()
				.setSettlementCurrency(thenArg17
					.mapSingleToItem(item -> {
						if (areEqual(item.<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All).or(exists(item.<CashSettlementTerms>mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms())).and(areEqual(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All))).getOrDefault(false)) {
							final FieldWithMetaString _fieldWithMetaString0 = item.<FieldWithMetaString>map("getSettlementCurrency", _settlementTerms -> _settlementTerms.getSettlementCurrency()).get();
							return MapperS.of(convertCurrency.evaluate((_fieldWithMetaString0 == null ? null : _fieldWithMetaString0.getValue())));
						}
						if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DIGITAL_OPTION), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.BARRIER_OPTION), CardinalityOperator.All)).getOrDefault(false)) {
							final MapperS<FieldWithMetaString> thenArg = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).<UnitType>map("getUnit", price -> price.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())
								.first();
							final FieldWithMetaString _fieldWithMetaString1 = thenArg.get();
							return MapperS.of(convertCurrency.evaluate((_fieldWithMetaString1 == null ? null : _fieldWithMetaString1.getValue())));
						}
						return MapperS.<String>ofNull();
					}).get());
			
			request
				.getOrCreateAttributes()
				.setPlaceofSettlement(MapperS.of(settlementTermsLeg1.evaluate(product(reportableEvent).get()))
					.mapSingleToItem(item -> {
						if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", _fieldWithMetaString0 -> _fieldWithMetaString0 == null ? null : _fieldWithMetaString0.getValue()), MapperS.of("ForeignExchange:ComplexExotic"), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get())))).and(areEqual(item.<SettlementTypeEnum>map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All)).or(exists(settlementTerms(reportableEvent).<CashSettlementTerms>mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms())).and(areEqual(settlementTerms(reportableEvent).<FieldWithMetaString>map("getSettlementCurrency", _settlementTerms -> _settlementTerms.getSettlementCurrency()).<String>map("Type coercion", _fieldWithMetaString1 -> _fieldWithMetaString1 == null ? null : _fieldWithMetaString1.getValue()), MapperS.of("CNH"), CardinalityOperator.All))).getOrDefault(false)) {
							return MapperS.of(AnnaDsbPlaceofSettlementEnum.HONG_KONG);
						}
						return MapperS.<AnnaDsbPlaceofSettlementEnum>ofNull();
					}).get());
			
			final AnnaDsbValuationMethodorTriggerEnum ifThenElseResult13;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DIGITAL_OPTION), CardinalityOperator.All).or(areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString11 -> fieldWithMetaString11 == null ? null : fieldWithMetaString11.getValue()), MapperS.of("ForeignExchange:ComplexExotic"), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult13 = AnnaDsbValuationMethodorTriggerEnum.DIGITAL_BINARY;
			} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.SWAPTION), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.SINGLE_NAME_SWAPTION), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INDEX_SWAPTION), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NDO), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT_OPTION), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult13 = AnnaDsbValuationMethodorTriggerEnum.VANILLA;
			} else {
				ifThenElseResult13 = null;
			}
			request
				.getOrCreateAttributes()
				.setValuationMethodorTrigger(ifThenElseResult13);
			
			final Integer ifThenElseResult14;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.CROSS_CURRENCY_FIXED_FIXED), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.FIXED_FIXED), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult14 = null;
			} else if (ComparisonResult.of(MapperS.of(qualify_InterestRate_Fra.evaluate(economicTerms(reportableEvent).get()))).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.FIXED_FLOAT_ZERO_COUPON), CardinalityOperator.All)).getOrDefault(false)) {
				if (exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier())).getOrDefault(false)) {
					ifThenElseResult14 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get();
				} else {
					final MapperC<InterestRatePayout> thenArg18 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
						.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
					final MapperC<InterestRatePayout> thenArg19 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
						.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
					ifThenElseResult14 = compute_IndexTermValue.evaluate(MapperS.of(thenArg18.get()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get(), MapperS.of(thenArg19.get()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get());
				}
			} else if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_Basis_YearOn_Year.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				final MapperC<InterestRatePayout> thenArg20 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
					.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).get());
				final MapperC<InterestRatePayout> thenArg21 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
					.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).get());
				ifThenElseResult14 = compute_IndexTermValue.evaluate(thenArg20
					.first().<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get(), thenArg21
					.first().<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get());
			} else {
				final Boolean boolean10 = qualify_InterestRate_CrossCurrency_Basis.evaluate(economicTerms(reportableEvent).get());
				if ((boolean10 == null ? false : boolean10)) {
					ifThenElseResult14 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption2 -> referenceWithMetaFloatingRateOption2 == null ? null : referenceWithMetaFloatingRateOption2.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get();
				} else {
					final Boolean boolean11 = qualify_InterestRate_CrossCurrency_FixedFloat.evaluate(economicTerms(reportableEvent).get());
					if ((boolean11 == null ? false : boolean11)) {
						if (exists(interestRatePayoutFloatingLeg(reportableEvent).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption3 -> referenceWithMetaFloatingRateOption3 == null ? null : referenceWithMetaFloatingRateOption3.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier())).getOrDefault(false)) {
							ifThenElseResult14 = interestRatePayoutFloatingLeg(reportableEvent).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption4 -> referenceWithMetaFloatingRateOption4 == null ? null : referenceWithMetaFloatingRateOption4.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get();
						} else if (exists(interestRatePayoutFloatingLeg(reportableEvent).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier())).getOrDefault(false)) {
							ifThenElseResult14 = interestRatePayoutFloatingLeg(reportableEvent).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier()).get();
						} else {
							ifThenElseResult14 = interestRatePayoutFloatingLeg(reportableEvent).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<Integer>map("getPeriodMultiplier", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriodMultiplier()).get();
						}
					} else {
						ifThenElseResult14 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()))
							.mapSingleToItem(item -> {
								if (areEqual(MapperS.of(qualify_AssetClass_Credit.evaluate(economicTerms(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All).or(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All).and(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())))).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any))).getOrDefault(false)) {
									if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption0 -> _referenceWithMetaFloatingRateOption0 == null ? null : _referenceWithMetaFloatingRateOption0.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier())).getOrDefault(false)) {
										return item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption1 -> _referenceWithMetaFloatingRateOption1 == null ? null : _referenceWithMetaFloatingRateOption1.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
									}
									if (exists(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier())).getOrDefault(false)) {
										return item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier());
									}
									return item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<Integer>map("getPeriodMultiplier", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriodMultiplier());
								}
								return MapperS.<Integer>ofNull();
							}).get();
					}
				}
			}
			request
				.getOrCreateAttributes()
				.setReferenceRateTermValue(ifThenElseResult14);
			
			final AnnaDsbUnderlyingInstrumentIndexTermUnitEnum ifThenElseResult15;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.CROSS_CURRENCY_FIXED_FIXED), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_IRSwap_FixedFixed.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult15 = null;
			} else if (ComparisonResult.of(MapperS.of(qualify_InterestRate_Fra.evaluate(economicTerms(reportableEvent).get()))).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.FIXED_FLOAT_ZERO_COUPON), CardinalityOperator.All)).getOrDefault(false)) {
				if (exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption5 -> referenceWithMetaFloatingRateOption5 == null ? null : referenceWithMetaFloatingRateOption5.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod())).getOrDefault(false)) {
					ifThenElseResult15 = translatePeriodEnum.evaluate(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption6 -> referenceWithMetaFloatingRateOption6 == null ? null : referenceWithMetaFloatingRateOption6.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get());
				} else {
					ifThenElseResult15 = AnnaDsbUnderlyingInstrumentIndexTermUnitEnum.YEAR;
				}
			} else if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_InflationSwap_Basis_YearOn_Year.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				if (exists(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor())).getOrDefault(false)) {
					final MapperS<Period> thenArg22 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor())
						.first();
					ifThenElseResult15 = MapperS.of(translatePeriodEnum.evaluate(thenArg22.<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get())).get();
				} else {
					ifThenElseResult15 = AnnaDsbUnderlyingInstrumentIndexTermUnitEnum.YEAR;
				}
			} else {
				final Boolean boolean12 = qualify_InterestRate_IRSwap_FixedFloat_OIS.evaluate(economicTerms(reportableEvent).get());
				if ((boolean12 == null ? false : boolean12)) {
					final MapperS<Period> thenArg23 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor())
						.first();
					ifThenElseResult15 = MapperS.of(translatePeriodEnum.evaluate(thenArg23.<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get())).get();
				} else {
					final Boolean boolean13 = qualify_InterestRate_CrossCurrency_Basis.evaluate(economicTerms(reportableEvent).get());
					if ((boolean13 == null ? false : boolean13)) {
						ifThenElseResult15 = translatePeriodEnum.evaluate(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption7 -> referenceWithMetaFloatingRateOption7 == null ? null : referenceWithMetaFloatingRateOption7.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get());
					} else {
						final Boolean boolean14 = qualify_InterestRate_CrossCurrency_FixedFloat.evaluate(economicTerms(reportableEvent).get());
						if ((boolean14 == null ? false : boolean14)) {
							if (exists(interestRatePayoutFloatingLeg(reportableEvent).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption8 -> referenceWithMetaFloatingRateOption8 == null ? null : referenceWithMetaFloatingRateOption8.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod())).getOrDefault(false)) {
								ifThenElseResult15 = translatePeriodEnum.evaluate(interestRatePayoutFloatingLeg(reportableEvent).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption9 -> referenceWithMetaFloatingRateOption9 == null ? null : referenceWithMetaFloatingRateOption9.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get());
							} else if (exists(interestRatePayoutFloatingLeg(reportableEvent).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod())).getOrDefault(false)) {
								ifThenElseResult15 = translatePeriodExtendedEnum.evaluate(interestRatePayoutFloatingLeg(reportableEvent).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()).get());
							} else {
								ifThenElseResult15 = translatePeriodExtendedEnum.evaluate(interestRatePayoutFloatingLeg(reportableEvent).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod()).get());
							}
						} else {
							ifThenElseResult15 = MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()))
								.mapSingleToItem(item -> {
									if (areEqual(MapperS.of(qualify_AssetClass_Credit.evaluate(economicTerms(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All).or(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get())), MapperS.of(false), CardinalityOperator.All).and(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())))).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any))).getOrDefault(false)) {
										if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption0 -> _referenceWithMetaFloatingRateOption0 == null ? null : _referenceWithMetaFloatingRateOption0.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod())).getOrDefault(false)) {
											return MapperS.of(translatePeriodEnum.evaluate(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption1 -> _referenceWithMetaFloatingRateOption1 == null ? null : _referenceWithMetaFloatingRateOption1.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get()));
										}
										if (exists(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod())).getOrDefault(false)) {
											return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()).get()));
										}
										return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod()).get()));
									}
									return MapperS.<AnnaDsbUnderlyingInstrumentIndexTermUnitEnum>ofNull();
								}).get();
						}
					}
				}
			}
			request
				.getOrCreateAttributes()
				.setReferenceRateTermUnit(ifThenElseResult15);
			
			final Integer ifThenElseResult16;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INFLATION_SWAP), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult16 = null;
			} else {
				ifThenElseResult16 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()))
					.mapSingleToItem(item -> {
						final Boolean _boolean = qualify_SubProduct_Basis.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
						if ((_boolean == null ? false : _boolean)) {
							if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption0 -> _referenceWithMetaFloatingRateOption0 == null ? null : _referenceWithMetaFloatingRateOption0.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier())).getOrDefault(false)) {
								return item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption1 -> _referenceWithMetaFloatingRateOption1 == null ? null : _referenceWithMetaFloatingRateOption1.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<Integer>map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
							}
							return item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier());
						}
						return MapperS.<Integer>ofNull();
					}).get();
			}
			request
				.getOrCreateAttributes()
				.setOtherLegReferenceRateTermValue(ifThenElseResult16);
			
			final AnnaDsbUnderlyingInstrumentIndexTermUnitEnum ifThenElseResult17;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INFLATION_SWAP), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult17 = null;
			} else {
				ifThenElseResult17 = MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()))
					.mapSingleToItem(item -> {
						final Boolean _boolean = qualify_SubProduct_Basis.evaluate(product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
						if ((_boolean == null ? false : _boolean)) {
							if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption0 -> _referenceWithMetaFloatingRateOption0 == null ? null : _referenceWithMetaFloatingRateOption0.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod())).getOrDefault(false)) {
								return MapperS.of(translatePeriodEnum.evaluate(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", _referenceWithMetaFloatingRateOption1 -> _referenceWithMetaFloatingRateOption1 == null ? null : _referenceWithMetaFloatingRateOption1.getValue()).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()).get()));
							}
							if (exists(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod())).getOrDefault(false)) {
								if (areEqual(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod()).get()));
								}
								return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()).get()));
							}
							return MapperS.<AnnaDsbUnderlyingInstrumentIndexTermUnitEnum>ofNull();
						}
						return MapperS.<AnnaDsbUnderlyingInstrumentIndexTermUnitEnum>ofNull();
					}).get();
			}
			request
				.getOrCreateAttributes()
				.setOtherLegReferenceRateTermUnit(ifThenElseResult17);
			
			request
				.getOrCreateAttributes()
				.setUnderlyingInstrumentIndexTermValue(MapperS.of(interestRateLeg1CapFloor.evaluate(product(reportableEvent).get()))
					.mapSingleToItem(item -> {
						final Boolean _boolean = isCapFloor.evaluate(product(reportableEvent).get());
						if ((_boolean == null ? false : _boolean)) {
							final MapperC<InterestRatePayout> _thenArg0 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
								.filterItemNullSafe(_item -> exists(_item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
							if (exists(_thenArg0
								.first()).asMapper().getOrDefault(false)) {
								final MapperC<InterestRatePayout> _thenArg1 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
									.filterItemNullSafe(_item -> exists(_item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
								final MapperC<InterestRatePayout> _thenArg2 = economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())
									.filterItemNullSafe(_item -> exists(_item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
								return MapperS.of(compute_IndexTermValue.evaluate(_thenArg1
									.first().<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get(), _thenArg2
									.first().<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).<Date>map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()).get()));
							}
							return item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier());
						}
						return MapperS.<Integer>ofNull();
					}).get());
			
			request
				.getOrCreateAttributes()
				.setUnderlyingInstrumentIndexTermUnit(MapperS.of(interestRateLeg1CapFloor.evaluate(product(reportableEvent).get()))
					.mapSingleToItem(item -> {
						final Boolean _boolean = isCapFloor.evaluate(product(reportableEvent).get());
						if ((_boolean == null ? false : _boolean)) {
							if (areEqual(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.T), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(AnnaDsbUnderlyingInstrumentIndexTermUnitEnum.YEAR);
							}
							if (areEqual(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod()).get()));
							}
							return MapperS.of(translatePeriodExtendedEnum.evaluate(item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()).get()));
						}
						return MapperS.<AnnaDsbUnderlyingInstrumentIndexTermUnitEnum>ofNull();
					}).get());
			
			final AnnaDsbDebtSeniorityEnum ifThenElseResult18;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult18 = null;
			} else if (ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_SingleName.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Loan.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult18 = debtSeniority.evaluate(product(reportableEvent).get(), useCase(reportableEvent).get());
			} else {
				ifThenElseResult18 = null;
			}
			request
				.getOrCreateAttributes()
				.setDebtSeniority(ifThenElseResult18);
			
			final Boolean boolean15 = qualify_CreditDefaultSwap_SingleName.evaluate(economicTerms(reportableEvent).get());
			AnnaDsbContractSpecificationEnum ifThenElseResult19 = null;
			if ((boolean15 == null ? false : boolean15)) {
				final FieldWithMetaString fieldWithMetaString12 = isdaTaxonomy(reportableEvent).get();
				ifThenElseResult19 = MapperS.of(replaceAll.evaluate((fieldWithMetaString12 == null ? null : fieldWithMetaString12.getValue()), "[^:]+:", "")).checkedMap("to-enum", AnnaDsbContractSpecificationEnum::fromDisplayName, IllegalArgumentException.class).get();
			}
			request
				.getOrCreateAttributes()
				.setContractSpecification(ifThenElseResult19);
			
			final AnnaDsbReturnorPayoutTriggerEnum ifThenElseResult20;
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString13 -> fieldWithMetaString13 == null ? null : fieldWithMetaString13.getValue()), MapperS.of("ForeignExchange:ComplexExotic"), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(isFXForward.evaluate(product(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult20 = AnnaDsbReturnorPayoutTriggerEnum.FORWARD_PRICE_OF_UNDERLYING_INSTRUMENT;
			} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT), CardinalityOperator.All).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult20 = AnnaDsbReturnorPayoutTriggerEnum.FORWARD_PRICE_OF_UNDERLYING_INSTRUMENT;
			} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_SingleName.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Basket.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_IndexTranche.evaluate(economicTerms(reportableEvent).get()))))).getOrDefault(false)) {
				ifThenElseResult20 = AnnaDsbReturnorPayoutTriggerEnum.OTHER;
			} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult20 = AnnaDsbReturnorPayoutTriggerEnum.TOTAL_RETURN;
			} else {
				ifThenElseResult20 = null;
			}
			request
				.getOrCreateAttributes()
				.setReturnorPayoutTrigger(ifThenElseResult20);
			
			AnnaDsbUnderlyingAssetTypeEnum ifThenElseResult21 = null;
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString14 -> fieldWithMetaString14 == null ? null : fieldWithMetaString14.getValue()), MapperS.of("ForeignExchange:ComplexExotic"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult21 = AnnaDsbUnderlyingAssetTypeEnum.SPOT;
			}
			request
				.getOrCreateAttributes()
				.setUnderlyingAssetType(ifThenElseResult21);
			
			AnnaDsbUnderlyingIssuerTypeEnum ifThenElseResult22 = null;
			if (ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Index.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_IndexTranche.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Loan.evaluate(economicTerms(reportableEvent).get())))).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.Any)).getOrDefault(false)) {
				ifThenElseResult22 = AnnaDsbUnderlyingIssuerTypeEnum.CORPORATE;
			}
			request
				.getOrCreateAttributes()
				.setUnderlyingIssuerType(ifThenElseResult22);
			
			final AnnaDsbUnderlying ifThenElseResult23;
			if (ComparisonResult.of(MapperS.of(isCreditDefaultSwap.evaluate(product(reportableEvent).get()))).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.SINGLE_NAME_SWAPTION), CardinalityOperator.Any)).and(notEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.INDEX_SWAPTION), CardinalityOperator.Any)).getOrDefault(false)) {
				if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult23 = create_AnnaDsbUpiRequestUnderlyingForCreditNonStandard.evaluate(product(reportableEvent).get());
				} else {
					ifThenElseResult23 = create_AnnaDsbUpiRequestUnderlyingForCredit.evaluate(product(reportableEvent).get(), useCase(reportableEvent).get());
				}
			} else if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.DEBT), CardinalityOperator.All).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult23 = create_AnnaDsbUpiRequestUnderlyingForRate.evaluate(product(reportableEvent).get(), tradeForEvent(reportableEvent).get(), useCase(reportableEvent).get());
			} else {
				ifThenElseResult23 = null;
			}
			request
				.getOrCreateAttributes()
				.setUnderlying(ifThenElseResult23);
			
			AnnaDsbOtherLegUnderlying ifThenElseResult24 = null;
			if (areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(qualify_SubProduct_Basis.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult24 = create_AnnaDsbUpiRequestOtherLegUnderlyingForRate.evaluate(product(reportableEvent).get(), tradeForEvent(reportableEvent).get(), useCase(reportableEvent).get());
			}
			request
				.getOrCreateAttributes()
				.setOtherLegUnderlying(ifThenElseResult24);
			
			AnnaDsbNotionalScheduleEnum ifThenElseResult25 = null;
			if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_Basis.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_FixedFloat.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CrossCurrency_FixedFixed.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				if (exists(leg1(reportableEvent)).and(areEqual(leg1(reportableEvent), leg2(reportableEvent), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult25 = leg1(reportableEvent).get();
				} else {
					ifThenElseResult25 = AnnaDsbNotionalScheduleEnum.CUSTOM;
				}
			}
			request
				.getOrCreateAttributes()
				.setNotionalSchedule(ifThenElseResult25);
			
			AnnaDsbBaseProduct ifThenElseResult26 = null;
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				ifThenElseResult26 = create_AnnaDsbUpiRequestBaseProductForCommodity.evaluate(product(reportableEvent).get());
			}
			request
				.getOrCreateAttributes()
				.setBaseProduct(ifThenElseResult26);
			
			return Optional.ofNullable(request)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends Trade> tradeForEvent(ReportableEvent reportableEvent) {
			if (exists(MapperS.of(reportableEvent).<TradeState>map("getReportableTrade", _reportableEvent -> _reportableEvent.getReportableTrade())).getOrDefault(false)) {
				return MapperS.of(reportableEvent).<TradeState>map("getReportableTrade", _reportableEvent -> _reportableEvent.getReportableTrade()).<Trade>map("getTrade", tradeState -> tradeState.getTrade());
			}
			return MapperS.of(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).get());
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
			return product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> isdaTaxonomy(ReportableEvent reportableEvent) {
			final MapperC<ProductTaxonomy> thenArg0 = product(reportableEvent).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy())
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(TaxonomySourceEnum.ISDA), CardinalityOperator.All).and(exists(item.<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<FieldWithMetaString>map("getName", taxonomyValue -> taxonomyValue.getName()))).get());
			final MapperS<ProductTaxonomy> thenArg1 = thenArg0
				.first();
			return thenArg1.<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<FieldWithMetaString>map("getName", taxonomyValue -> taxonomyValue.getName());
		}
		
		@Override
		protected MapperS<Boolean> isSwaption(ReportableEvent reportableEvent) {
			return ComparisonResult.of(MapperS.of(isCreditSwaption.evaluate(tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).or(ComparisonResult.of(MapperS.of(isIRSwaption.evaluate(tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).asMapper();
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			if (isSwaption(reportableEvent).getOrDefault(false)) {
				final MapperC<ReferenceWithMetaProductIdentifier> thenArg = MapperS.of(tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())
					.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.UPI), CardinalityOperator.All).get());
				if (notExists(thenArg).asMapper().getOrDefault(false)) {
					return MapperS.of(tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier());
				}
				return tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct());
			}
			return tradeForEvent(reportableEvent).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct());
		}
		
		@Override
		protected MapperS<Boolean> isOption1(ReportableEvent reportableEvent) {
			return MapperS.of(isOption0.evaluate(product(reportableEvent).get()));
		}
		
		@Override
		protected MapperS<AnnaDsbUseCaseEnum> useCase(ReportableEvent reportableEvent) {
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), MapperS.of("ForeignExchange:SimpleExotic:Digital"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.DIGITAL_OPTION);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), MapperS.of("ForeignExchange:SimpleExotic:Barrier"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.BARRIER_OPTION);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString2 -> fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()), MapperS.of("ForeignExchange:NDO"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NDO);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString3 -> fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue()), MapperS.of("ForeignExchange:ComplexExotic"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD);
			}
			final Boolean boolean0 = qualify_ForeignExchange_VanillaOption.evaluate(economicTerms(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(AnnaDsbUseCaseEnum.VANILLA_OPTION);
			}
			final Boolean boolean1 = qualify_ForeignExchange_Spot_Forward.evaluate(economicTerms(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FORWARD);
			}
			final Boolean boolean2 = qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get());
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FX_SWAP);
			}
			final Boolean boolean3 = qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get());
			if ((boolean3 == null ? false : boolean3)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NON_DELIVERABLE_FX_SWAP);
			}
			final Boolean boolean4 = qualify_ForeignExchange_NDF.evaluate(economicTerms(reportableEvent).get());
			if ((boolean4 == null ? false : boolean4)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NDF);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString4 -> fieldWithMetaString4 == null ? null : fieldWithMetaString4.getValue()), MapperS.of("InterestRate:Exotic"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString5 -> fieldWithMetaString5 == null ? null : fieldWithMetaString5.getValue()), MapperS.of("InterestRate:Forward:Debt"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.DEBT);
			}
			if (areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString6 -> fieldWithMetaString6 == null ? null : fieldWithMetaString6.getValue()), MapperS.of("InterestRate:FRA"), CardinalityOperator.All).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FRA_INDEX);
			}
			final Boolean boolean5 = qualify_InterestRate_IRSwap_FixedFloat.evaluate(economicTerms(reportableEvent).get());
			if ((boolean5 == null ? false : boolean5)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FIXED_FLOAT);
			}
			final Boolean boolean6 = qualify_InterestRate_IRSwap_FixedFixed.evaluate(economicTerms(reportableEvent).get());
			if ((boolean6 == null ? false : boolean6)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FIXED_FIXED);
			}
			final Boolean boolean7 = qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year.evaluate(economicTerms(reportableEvent).get());
			if ((boolean7 == null ? false : boolean7)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INFLATION_FIXED_FLOAT_YO_Y);
			}
			final Boolean boolean8 = qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon.evaluate(economicTerms(reportableEvent).get());
			if ((boolean8 == null ? false : boolean8)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INFLATION_FIXED_FLOAT_ZERO_COUPON);
			}
			final Boolean boolean9 = qualify_InterestRate_InflationSwap_Basis_YearOn_Year.evaluate(economicTerms(reportableEvent).get());
			if ((boolean9 == null ? false : boolean9)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INFLATION_BASIS_YO_Y);
			}
			final Boolean boolean10 = qualify_InterestRate_InflationSwap_Basis_ZeroCoupon.evaluate(economicTerms(reportableEvent).get());
			if ((boolean10 == null ? false : boolean10)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INFLATION_BASIS_ZERO_COUPON);
			}
			final Boolean boolean11 = qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get());
			if ((boolean11 == null ? false : boolean11)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INFLATION_SWAP);
			}
			final Boolean boolean12 = qualify_InterestRate_CrossCurrency_FixedFixed.evaluate(economicTerms(reportableEvent).get());
			if ((boolean12 == null ? false : boolean12)) {
				return MapperS.of(AnnaDsbUseCaseEnum.CROSS_CURRENCY_FIXED_FIXED);
			}
			final Boolean boolean13 = qualify_InterestRate_CrossCurrency_FixedFloat.evaluate(economicTerms(reportableEvent).get());
			if ((boolean13 == null ? false : boolean13)) {
				return MapperS.of(AnnaDsbUseCaseEnum.CROSS_CURRENCY_FIXED_FLOAT);
			}
			final Boolean boolean14 = qualify_InterestRate_IRSwap_Basis.evaluate(economicTerms(reportableEvent).get());
			if ((boolean14 == null ? false : boolean14)) {
				return MapperS.of(AnnaDsbUseCaseEnum.BASIS);
			}
			final Boolean boolean15 = qualify_InterestRate_IRSwap_Basis_OIS.evaluate(economicTerms(reportableEvent).get());
			if ((boolean15 == null ? false : boolean15)) {
				return MapperS.of(AnnaDsbUseCaseEnum.BASIS_OIS);
			}
			final Boolean boolean16 = qualify_InterestRate_IRSwap_FixedFloat_ZeroCoupon.evaluate(economicTerms(reportableEvent).get());
			if ((boolean16 == null ? false : boolean16)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FIXED_FLOAT_ZERO_COUPON);
			}
			final Boolean boolean17 = qualify_InterestRate_IRSwap_FixedFloat_OIS.evaluate(economicTerms(reportableEvent).get());
			if ((boolean17 == null ? false : boolean17)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FIXED_FLOAT_OIS);
			}
			final Boolean boolean18 = qualify_InterestRate_CrossCurrency_Basis.evaluate(economicTerms(reportableEvent).get());
			if ((boolean18 == null ? false : boolean18)) {
				return MapperS.of(AnnaDsbUseCaseEnum.CROSS_CURRENCY_BASIS);
			}
			final Boolean boolean19 = qualify_InterestRate_Option_Swaption.evaluate(economicTerms(reportableEvent).get());
			if ((boolean19 == null ? false : boolean19)) {
				return MapperS.of(AnnaDsbUseCaseEnum.SWAPTION);
			}
			final Boolean boolean20 = qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get());
			if ((boolean20 == null ? false : boolean20)) {
				return MapperS.of(AnnaDsbUseCaseEnum.CAP_FLOOR);
			}
			final Boolean boolean21 = qualify_InterestRate_Option_DebtOption.evaluate(economicTerms(reportableEvent).get());
			if ((boolean21 == null ? false : boolean21)) {
				return MapperS.of(AnnaDsbUseCaseEnum.DEBT_OPTION);
			}
			final Boolean boolean22 = qualify_CreditDefaultSwap_Loan.evaluate(economicTerms(reportableEvent).get());
			if ((boolean22 == null ? false : boolean22)) {
				return MapperS.of(AnnaDsbUseCaseEnum.LOAN);
			}
			final Boolean boolean23 = qualify_CreditDefaultSwap_Index.evaluate(economicTerms(reportableEvent).get());
			if ((boolean23 == null ? false : boolean23)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INDEX);
			}
			final Boolean boolean24 = qualify_CreditDefaultSwap_IndexTranche.evaluate(economicTerms(reportableEvent).get());
			if ((boolean24 == null ? false : boolean24)) {
				return MapperS.of(AnnaDsbUseCaseEnum.INDEX_TRANCHE);
			}
			final Boolean boolean25 = qualify_CreditDefaultSwaption.evaluate(economicTerms(reportableEvent).get());
			if ((boolean25 == null ? false : boolean25)) {
				final Boolean boolean26 = qualify_CreditDefaultSwap_SingleName.evaluate(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
				if ((boolean26 == null ? false : boolean26)) {
					return MapperS.of(AnnaDsbUseCaseEnum.SINGLE_NAME_SWAPTION);
				}
				final Boolean boolean27 = qualify_CreditDefaultSwap_Index.evaluate(MapperS.of(underlierForProduct.evaluate(product(reportableEvent).get())).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
				if ((boolean27 == null ? false : boolean27)) {
					return MapperS.of(AnnaDsbUseCaseEnum.INDEX_SWAPTION);
				}
				return MapperS.<AnnaDsbUseCaseEnum>ofNull();
			}
			final FieldWithMetaString fieldWithMetaString7 = isdaTaxonomy(reportableEvent).get();
			final Boolean boolean28 = stringContains.evaluate((fieldWithMetaString7 == null ? null : fieldWithMetaString7.getValue()), "^Credit:SingleName:Corporate:.*");
			if ((boolean28 == null ? false : boolean28)) {
				return MapperS.of(AnnaDsbUseCaseEnum.CORPORATE);
			}
			final FieldWithMetaString fieldWithMetaString8 = isdaTaxonomy(reportableEvent).get();
			final Boolean boolean29 = stringContains.evaluate((fieldWithMetaString8 == null ? null : fieldWithMetaString8.getValue()), "^Credit:SingleName:Sovereign:.*");
			if ((boolean29 == null ? false : boolean29)) {
				return MapperS.of(AnnaDsbUseCaseEnum.SOVEREIGN);
			}
			final FieldWithMetaString fieldWithMetaString9 = isdaTaxonomy(reportableEvent).get();
			final Boolean boolean30 = stringContains.evaluate((fieldWithMetaString9 == null ? null : fieldWithMetaString9.getValue()), "^Credit:SingleName:Muni:.*");
			if ((boolean30 == null ? false : boolean30)) {
				return MapperS.of(AnnaDsbUseCaseEnum.MUNICIPAL);
			}
			final FieldWithMetaString fieldWithMetaString10 = isdaTaxonomy(reportableEvent).get();
			final Boolean boolean31 = stringContains.evaluate((fieldWithMetaString10 == null ? null : fieldWithMetaString10.getValue()), "^Credit:TotalReturnSwap.*");
			if ((boolean31 == null ? false : boolean31)) {
				return MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP);
			}
			final FieldWithMetaString fieldWithMetaString11 = isdaTaxonomy(reportableEvent).get();
			final Boolean boolean32 = stringContains.evaluate((fieldWithMetaString11 == null ? null : fieldWithMetaString11.getValue()), "^Credit:Exotic.*");
			if ((boolean32 == null ? false : boolean32)) {
				return MapperS.of(AnnaDsbUseCaseEnum.NON_STANDARD);
			}
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				return MapperS.of(AnnaDsbUseCaseEnum.SWAP);
			}
			final Boolean boolean33 = qualify_Commodity_Swaption.evaluate(economicTerms(reportableEvent).get());
			if ((boolean33 == null ? false : boolean33)) {
				return MapperS.of(AnnaDsbUseCaseEnum.SWAPTION);
			}
			final Boolean boolean34 = qualify_Commodity_Option.evaluate(economicTerms(reportableEvent).get());
			if ((boolean34 == null ? false : boolean34)) {
				return MapperS.of(AnnaDsbUseCaseEnum.OPTION);
			}
			final Boolean boolean35 = qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get());
			if ((boolean35 == null ? false : boolean35)) {
				return MapperS.of(AnnaDsbUseCaseEnum.FORWARD);
			}
			return MapperS.<AnnaDsbUseCaseEnum>ofNull();
		}
		
		@Override
		protected MapperS<? extends SettlementTerms> settlementTerms(ReportableEvent reportableEvent) {
			return MapperC.<SettlementTerms>of(economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()), economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()), economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<SettlementTerms>map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()), economicTerms(reportableEvent).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<SettlementTerms>map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms()))
				.first();
		}
		
		@Override
		protected MapperS<AnnaDsbNotionalScheduleEnum> leg1(ReportableEvent reportableEvent) {
			final Boolean _boolean = qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get());
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(compute_NotionalScheduleType.evaluate(MapperS.of(getLeg1ResolvablePriceQuantity.evaluate(tradeForEvent(reportableEvent).get())).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).getMulti()));
			}
			return MapperS.<AnnaDsbNotionalScheduleEnum>ofNull();
		}
		
		@Override
		protected MapperS<AnnaDsbNotionalScheduleEnum> leg2(ReportableEvent reportableEvent) {
			final Boolean _boolean = qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get());
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(compute_NotionalScheduleType.evaluate(MapperS.of(getLeg2ResolvablePriceQuantity.evaluate(tradeForEvent(reportableEvent).get())).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).getMulti()));
			}
			return MapperS.<AnnaDsbNotionalScheduleEnum>ofNull();
		}
		
		@Override
		protected MapperS<? extends InterestRatePayout> interestRatePayoutFloatingLeg(ReportableEvent reportableEvent) {
			if (exists(MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(false)) {
				return MapperS.of(interestRateLeg1.evaluate(product(reportableEvent).get()));
			}
			if (exists(MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).getOrDefault(false)) {
				return MapperS.of(interestRateLeg2.evaluate(product(reportableEvent).get()));
			}
			return MapperS.<InterestRatePayout>ofNull();
		}
		
		@Override
		protected MapperS<AnnaDsbInstrumentTypeEnum> instrumentType(ReportableEvent reportableEvent) {
			if (ComparisonResult.of(isOption1(reportableEvent)).or(ComparisonResult.of(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwaption.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				return MapperS.of(AnnaDsbInstrumentTypeEnum.OPTION);
			}
			if (ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_EquitySwap.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_BaseProduct_Inflation.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_SingleName.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Basket.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_Index.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_CreditDefaultSwap_IndexTranche.evaluate(economicTerms(reportableEvent).get())))).or(areEqual(useCase(reportableEvent), MapperS.of(AnnaDsbUseCaseEnum.TOTAL_RETURN_SWAP), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get())))).getOrDefault(false)) {
				return MapperS.of(AnnaDsbInstrumentTypeEnum.SWAP);
			}
			if (ComparisonResult.of(MapperS.of(qualify_BaseProduct_Fra.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDF.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(economicTerms(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Forward.evaluate(economicTerms(reportableEvent).get())))).or(areEqual(isdaTaxonomy(reportableEvent).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), MapperS.of("InterestRate:Forward:Debt"), CardinalityOperator.All)).getOrDefault(false)) {
				return MapperS.of(AnnaDsbInstrumentTypeEnum.FORWARD);
			}
			return MapperS.<AnnaDsbInstrumentTypeEnum>ofNull();
		}
	}
}
